/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.mail.extension;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.mail.extension.DirectMailSessionService;
import org.jboss.as.mail.extension.MailLogger;
import org.jboss.as.mail.extension.MailSessionAdd;
import org.jboss.as.mail.extension.MailSessionManagedReferenceFactory;
import org.jboss.as.mail.extension.MailSessionService;
import org.jboss.as.mail.extension.SessionProvider;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

class MailSessionDefinitionInjectionSource
extends ResourceDefinitionInjectionSource {
    private final SessionProvider provider;

    public MailSessionDefinitionInjectionSource(String jndiName, SessionProvider provider) {
        super(jndiName);
        this.provider = provider;
    }

    public void getResourceValue(InjectionSource.ResolutionContext context, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        try {
            DirectMailSessionService mailSessionService = new DirectMailSessionService(this.provider);
            this.startMailSession(mailSessionService, this.jndiName, eeModuleDescription, context, phaseContext.getServiceTarget(), serviceBuilder, injector);
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private void startMailSession(MailSessionService mailSessionService, final String jndiName, EEModuleDescription moduleDescription, InjectionSource.ResolutionContext context, ServiceTarget serviceTarget, ServiceBuilder<?> valueSourceServiceBuilder, Injector<ManagedReferenceFactory> injector) {
        ServiceName mailSessionServiceName = MailSessionAdd.MAIL_SESSION_SERVICE_NAME.append(new String[]{"MailSessionDefinition", moduleDescription.getApplicationName(), moduleDescription.getModuleName(), jndiName});
        ServiceBuilder mailSessionServiceBuilder = serviceTarget.addService(mailSessionServiceName, (Service)mailSessionService);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoForEnvEntry((String)context.getApplicationName(), (String)context.getModuleName(), (String)context.getComponentName(), (!context.isCompUsesModule() ? 1 : 0) != 0, (String)jndiName);
        MailSessionManagedReferenceFactory referenceFactoryService = new MailSessionManagedReferenceFactory(mailSessionService);
        BinderService binderService = new BinderService(bindInfo.getBindName(), (Object)this);
        ServiceBuilder binderBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addInjection((Injector)binderService.getManagedObjectInjector(), (Object)referenceFactoryService).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        MailLogger.ROOT_LOGGER.boundMailSession(jndiName);
                        break;
                    }
                    case START_REQUESTED_to_DOWN: {
                        MailLogger.ROOT_LOGGER.unboundMailSession(jndiName);
                        break;
                    }
                    case REMOVING_to_REMOVED: {
                        MailLogger.ROOT_LOGGER.debugf("Removed Mail Session [%s]", jndiName);
                    }
                }
            }
        });
        mailSessionServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        valueSourceServiceBuilder.addDependency(bindInfo.getBinderServiceName(), ManagedReferenceFactory.class, injector);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MailSessionDefinitionInjectionSource that = (MailSessionDefinitionInjectionSource)((Object)o);
        return !(this.provider != null ? !this.provider.equals(that.provider) : that.provider != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
        return result;
    }
}

