/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;

@MessageLogger(projectCode="PROBE-")
public interface ProbeLogger
extends BasicLogger {
    public static final ProbeLogger LOG = (ProbeLogger)Logger.getMessageLogger(ProbeLogger.class, (String)"org.jboss.weld.probe.Probe");
    public static final String CATCHING_MARKER = "Catching";

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=0, value="Catching")
    public void catchingTrace(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=1, value="Resource {0} matched for {1}", format=Message.Format.MESSAGE_FORMAT)
    public void resourceMatched(Object var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Processing bean deployment archive: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void processingBeanDeploymentArchive(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="A problem occured during contextual instance introspection: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void introspectionProblem(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=4, value="Filters applied: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void filtersApplied(Object var1);

    @Message(id=5, value="Probe is not properly initialized")
    public IllegalStateException probeNotInitialized();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=6, value="{0} not monitored - excluded", format=Message.Format.MESSAGE_FORMAT)
    public void invocationMonitorNotAssociatedExcluded(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8, value="\n=====================================\n Weld Development Mode: ENABLED\n ------------------------------------\n Disable this mode in production - it may have negative impact on performance and/or represent a potential security risk\n=====================================")
    public void developmentModeEnabled();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=9, value="@MonitoredComponent stereotype added to {0}", format=Message.Format.MESSAGE_FORMAT)
    public void monitoringStereotypeAdded(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10, value="{0} not monitored - non-proxyable type", format=Message.Format.MESSAGE_FORMAT)
    public void invocationMonitorNotAssociatedNonProxyableType(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=11, value="Event {0} not monitored - excluded", format=Message.Format.MESSAGE_FORMAT)
    public void eventExcluded(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=12, value="{0} monitoring limit {1} exceed - some old data were removed", format=Message.Format.MESSAGE_FORMAT)
    public void monitoringLimitExceeded(Object var1, Object var2);

    @Message(id=13, value="Probe filter is not able to operate - missing {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException probeFilterUnableToOperate(Class<?> var1);

    @Message(id=14, value="Cannot register a Probe MBean {0} for: {1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException unableToRegisterMBean(Object var1, Object var2, @Cause Throwable var3);

    @Message(id=15, value="Cannot unregister a Probe MBean {0} for: {1}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException unableToUnregisterMBean(Object var1, Object var2, @Cause Throwable var3);

    @Message(id=16, value="Unable to parse query filters: {0}", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException unableToParseQueryFilter(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17, value="Access to {0} denied for {1}", format=Message.Format.MESSAGE_FORMAT)
    public void requestDenied(Object var1, Object var2);
}

