/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.CopyableDeltaAware;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.NullDelta;
import org.infinispan.atomic.impl.AtomicHashMapDelta;
import org.infinispan.atomic.impl.AtomicHashMapProxy;
import org.infinispan.atomic.impl.ClearOperation;
import org.infinispan.atomic.impl.FineGrainedAtomicHashMapProxy;
import org.infinispan.atomic.impl.PutOperation;
import org.infinispan.atomic.impl.RemoveOperation;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.FastCopyHashMap;
import org.infinispan.commons.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@NotThreadSafe
public final class AtomicHashMap<K, V>
implements AtomicMap<K, V>,
CopyableDeltaAware,
Cloneable {
    private static final Log log = LogFactory.getLog(AtomicHashMap.class);
    private static final boolean trace = log.isTraceEnabled();
    protected final FastCopyHashMap<K, V> delegate;
    private AtomicHashMapDelta delta = null;
    private volatile AtomicHashMapProxy<K, V> proxy;
    volatile boolean copied = false;
    volatile boolean removed = false;

    public static <K, V> AtomicHashMap<K, V> newInstance(Cache<Object, Object> cache, Object cacheKey) {
        AtomicHashMap value = new AtomicHashMap();
        Object oldValue = cache.putIfAbsent(cacheKey, value);
        if (oldValue != null) {
            value = (AtomicHashMap)oldValue;
        }
        return value;
    }

    public AtomicHashMap() {
        this.delegate = new FastCopyHashMap();
    }

    private AtomicHashMap(FastCopyHashMap<K, V> delegate) {
        this.delegate = delegate;
    }

    public AtomicHashMap(boolean isCopy) {
        this();
        this.copied = isCopy;
    }

    private AtomicHashMap(FastCopyHashMap<K, V> newDelegate, AtomicHashMapProxy<K, V> proxy) {
        this.delegate = newDelegate;
        this.proxy = proxy;
        this.copied = true;
    }

    @Override
    public void commit() {
        this.copied = false;
        this.delta = null;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        Object v = this.delegate.get(key);
        if (trace) {
            log.tracef("Atomic hash map get(key=%s) returns %s", key, v);
        }
        return (V)v;
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public V put(K key, V value) {
        Object oldValue = this.delegate.put(key, value);
        PutOperation<K, Object> op = new PutOperation<K, Object>(key, oldValue, value);
        this.getDelta().addOperation(op);
        return (V)oldValue;
    }

    @Override
    public V remove(Object key) {
        Object oldValue = this.delegate.remove(key);
        RemoveOperation<Object, Object> op = new RemoveOperation<Object, Object>(key, oldValue);
        this.getDelta().addOperation(op);
        return (V)oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        FastCopyHashMap originalEntries = this.delegate.clone();
        ClearOperation op = new ClearOperation(originalEntries);
        this.getDelta().addOperation(op);
        this.delegate.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicHashMapProxy<K, V> getProxy(AdvancedCache<Object, Object> cache, Object mapKey, boolean fineGrained) {
        if (this.proxy == null) {
            AtomicHashMap atomicHashMap = this;
            synchronized (atomicHashMap) {
                if (this.proxy == null) {
                    this.proxy = fineGrained ? new FineGrainedAtomicHashMapProxy(cache, mapKey) : new AtomicHashMapProxy(cache, mapKey);
                }
            }
        }
        return this.proxy;
    }

    public void markRemoved(boolean b) {
        this.removed = b;
    }

    @Override
    public Delta delta() {
        Delta toReturn = this.delta == null ? NullDelta.INSTANCE : this.delta;
        this.delta = null;
        return toReturn;
    }

    @Override
    public AtomicHashMap<K, V> copy() {
        FastCopyHashMap newDelegate = this.delegate.clone();
        return new AtomicHashMap<K, V>(newDelegate, this.proxy);
    }

    public String toString() {
        return "AtomicHashMap{size=" + this.size() + "}";
    }

    public void initForWriting() {
        this.delta = new AtomicHashMapDelta();
    }

    AtomicHashMapDelta getDelta() {
        if (this.delta == null) {
            this.delta = new AtomicHashMapDelta();
        }
        return this.delta;
    }

    public static class Externalizer
    extends AbstractExternalizer<AtomicHashMap> {
        public void writeObject(ObjectOutput output, AtomicHashMap map) throws IOException {
            output.writeObject(map.delegate);
        }

        public AtomicHashMap readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            FastCopyHashMap delegate = (FastCopyHashMap)input.readObject();
            if (trace) {
                log.tracef("Restore atomic hash map from %s", delegate);
            }
            return new AtomicHashMap(delegate);
        }

        public Integer getId() {
            return 20;
        }

        public Set<Class<? extends AtomicHashMap>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{AtomicHashMap.class});
        }
    }
}

