/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.util.Set;
import java.util.function.BiConsumer;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;

public final class WriteOnlyKeyValueCommand<K, V>
extends AbstractWriteKeyCommand<K, V> {
    public static final byte COMMAND_ID = 55;
    private BiConsumer<V, EntryView.WriteEntryView<V>> f;
    private V value;

    public WriteOnlyKeyValueCommand(K key, V value, BiConsumer<V, EntryView.WriteEntryView<V>> f, CommandInvocationId id, ValueMatcher valueMatcher, Params params) {
        super(key, valueMatcher, id, params);
        this.f = f;
        this.value = value;
    }

    public WriteOnlyKeyValueCommand() {
    }

    @Override
    public byte getCommandId() {
        return 55;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 55) {
            throw new IllegalStateException("Invalid method id");
        }
        this.key = parameters[0];
        this.value = parameters[1];
        this.f = (BiConsumer)parameters[2];
        this.valueMatcher = (ValueMatcher)((Object)parameters[3]);
        this.flags = (Set)parameters[4];
        this.commandInvocationId = (CommandInvocationId)parameters[5];
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.value, this.f, this.valueMatcher, Flag.copyWithoutRemotableFlags(this.flags), this.commandInvocationId};
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry e = ctx.lookupEntry(this.key);
        if (e == null) {
            return null;
        }
        this.f.accept(this.value, EntryViews.writeOnly(e));
        return null;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitWriteOnlyKeyValueCommand(ctx, this);
    }

    @Override
    public boolean readsExistingValues() {
        return false;
    }

    @Override
    public boolean alwaysReadsExistingValues() {
        return false;
    }

    @Override
    public boolean isWriteOnly() {
        return true;
    }
}

