/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jmx.JMXExtension;
import org.jboss.as.jmx.RemotingConnectorAdd;
import org.jboss.as.jmx.RemotingConnectorRemove;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class RemotingConnectorResource
extends SimpleResourceDefinition {
    static final PathElement REMOTE_CONNECTOR_CONFIG_PATH = PathElement.pathElement((String)"remoting-connector", (String)"jmx");
    static final SimpleAttributeDefinition USE_MANAGEMENT_ENDPOINT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-management-endpoint", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true))).setAllowExpression(true)).build();
    static final String REMOTING_CAPABILITY = "org.wildfly.remoting.endpoint";
    static final RuntimeCapability<Void> REMOTE_JMX_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.management.jmx.remote").addRequirements(new String[]{"org.wildfly.management.jmx"}).build();
    static final RemotingConnectorResource INSTANCE = new RemotingConnectorResource();

    private RemotingConnectorResource() {
        super(REMOTE_CONNECTOR_CONFIG_PATH, JMXExtension.getResourceDescriptionResolver("remoting-connector"), (OperationStepHandler)RemotingConnectorAdd.INSTANCE, (OperationStepHandler)RemotingConnectorRemove.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{USE_MANAGEMENT_ENDPOINT}){

            protected void recordCapabilitiesAndRequirements(OperationContext context, AttributeDefinition attributeDefinition, ModelNode newValue, ModelNode oldValue) {
                super.recordCapabilitiesAndRequirements(context, attributeDefinition, newValue, oldValue);
                Boolean needRemoting = this.needRemoting(context, newValue);
                if (needRemoting != null) {
                    if (needRemoting.booleanValue()) {
                        context.registerAdditionalCapabilityRequirement(RemotingConnectorResource.REMOTING_CAPABILITY, REMOTE_JMX_CAPABILITY.getName(), USE_MANAGEMENT_ENDPOINT.getName());
                    } else {
                        context.deregisterCapabilityRequirement(RemotingConnectorResource.REMOTING_CAPABILITY, REMOTE_JMX_CAPABILITY.getName());
                    }
                }
            }

            private Boolean needRemoting(OperationContext context, ModelNode attributeValue) {
                ModelNode model = new ModelNode();
                model.get(USE_MANAGEMENT_ENDPOINT.getName()).set(attributeValue);
                try {
                    return !USE_MANAGEMENT_ENDPOINT.resolveModelAttribute(context, model).asBoolean();
                }
                catch (OperationFailedException ofe) {
                    if (model.get(USE_MANAGEMENT_ENDPOINT.getName()).getType() == ModelType.EXPRESSION) {
                        return null;
                    }
                    throw new IllegalStateException(ofe);
                }
            }
        };
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)USE_MANAGEMENT_ENDPOINT, null, (OperationStepHandler)writeHandler);
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerCapability(REMOTE_JMX_CAPABILITY);
    }
}

