/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.util;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageListener;
import javax.transaction.TransactionManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.jms.util.JMSListenerContainer;
import org.apache.cxf.transport.jms.util.MessageListenerContainer;

public abstract class AbstractMessageListenerContainer
implements JMSListenerContainer {
    protected static final Logger LOG = LogUtils.getL7dLogger(MessageListenerContainer.class);
    protected Connection connection;
    protected Destination destination;
    protected MessageListener listenerHandler;
    protected boolean transacted;
    protected int acknowledgeMode = 1;
    protected String messageSelector;
    protected boolean running;
    protected Executor executor;
    protected String durableSubscriptionName;
    protected boolean pubSubNoLocal;
    protected TransactionManager transactionManager;

    public Connection getConnection() {
        return this.connection;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
        if (this.transacted) {
            this.acknowledgeMode = 0;
        }
    }

    public void setAcknowledgeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    protected Executor getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(10);
        }
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

