/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.vault;

import java.io.Console;
import java.util.InputMismatchException;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.vault.VaultInteractiveSession;
import org.jboss.as.security.vault.VaultSession;

public class VaultTool {
    public static final String KEYSTORE_PARAM = "keystore";
    public static final String KEYSTORE_PASSWORD_PARAM = "keystore-password";
    public static final String ENC_DIR_PARAM = "enc-dir";
    public static final String SALT_PARAM = "salt";
    public static final String ITERATION_PARAM = "iteration";
    public static final String ALIAS_PARAM = "alias";
    public static final String VAULT_BLOCK_PARAM = "vault-block";
    public static final String ATTRIBUTE_PARAM = "attribute";
    public static final String SEC_ATTR_VALUE_PARAM = "sec-attr";
    public static final String CHECK_SEC_ATTR_EXISTS_PARAM = "check-sec-attr";
    public static final String REMOVE_SEC_ATTR_PARAM = "remove-sec-attr";
    public static final String CREATE_KEYSTORE_PARAM = "create-keystore";
    public static final String HELP_PARAM = "help";
    private VaultInteractiveSession session = null;
    private VaultSession nonInteractiveSession = null;
    private Options options = null;
    private CommandLineParser parser = null;
    private CommandLine cmdLine = null;

    public void setSession(VaultInteractiveSession sess) {
        this.session = sess;
    }

    public VaultInteractiveSession getSession() {
        return this.session;
    }

    public static void main(String[] args) {
        int returnVal;
        VaultTool tool = null;
        if (args != null && args.length > 0) {
            returnVal = 0;
            try {
                tool = new VaultTool(args);
                returnVal = tool.execute();
            }
            catch (Exception e) {
                System.err.println(SecurityLogger.ROOT_LOGGER.problemOcurred());
                e.printStackTrace(System.err);
                System.exit(1);
            }
        } else {
            tool = new VaultTool();
            System.out.println("**********************************");
            System.out.println("****  JBoss Vault  ***************");
            System.out.println("**********************************");
            Console console = System.console();
            if (console == null) {
                System.err.println(SecurityLogger.ROOT_LOGGER.noConsole());
                System.exit(1);
            }
            Scanner in = new Scanner(System.in);
            block8: while (true) {
                System.out.println(SecurityLogger.ROOT_LOGGER.interactiveCommandString());
                try {
                    int choice = in.nextInt();
                    switch (choice) {
                        case 0: {
                            System.out.println(SecurityLogger.ROOT_LOGGER.startingInteractiveSession());
                            VaultInteractiveSession vsession = new VaultInteractiveSession();
                            tool.setSession(vsession);
                            vsession.start();
                            continue block8;
                        }
                        case 1: {
                            System.out.println(SecurityLogger.ROOT_LOGGER.removingInteractiveSession());
                            tool.setSession(null);
                            continue block8;
                        }
                    }
                    in.close();
                    System.exit(0);
                }
                catch (InputMismatchException e) {
                    in.close();
                    System.exit(0);
                }
            }
        }
        System.exit(returnVal);
    }

    public VaultTool(String[] args) {
        this.initOptions();
        this.parser = new PosixParser();
        try {
            this.cmdLine = this.parser.parse(this.options, args, true);
        }
        catch (ParseException e) {
            System.out.println(SecurityLogger.ROOT_LOGGER.problemParsingCommandLineParameters());
            e.printStackTrace(System.err);
            System.exit(2);
        }
    }

    public VaultTool() {
    }

    private void initOptions() {
        this.options = new Options();
        this.options.addOption("k", KEYSTORE_PARAM, true, SecurityLogger.ROOT_LOGGER.cmdLineKeyStoreURL());
        this.options.addOption("p", KEYSTORE_PASSWORD_PARAM, true, SecurityLogger.ROOT_LOGGER.cmdLineKeyStorePassword());
        this.options.addOption("e", ENC_DIR_PARAM, true, SecurityLogger.ROOT_LOGGER.cmdLineEncryptionDirectory());
        this.options.addOption("s", SALT_PARAM, true, SecurityLogger.ROOT_LOGGER.cmdLineSalt());
        this.options.addOption("i", ITERATION_PARAM, true, SecurityLogger.ROOT_LOGGER.cmdLineIterationCount());
        this.options.addOption("v", ALIAS_PARAM, true, SecurityLogger.ROOT_LOGGER.cmdLineVaultKeyStoreAlias());
        this.options.addOption("b", VAULT_BLOCK_PARAM, true, SecurityLogger.ROOT_LOGGER.cmdLineVaultBlock());
        this.options.addOption("a", ATTRIBUTE_PARAM, true, SecurityLogger.ROOT_LOGGER.cmdLineAttributeName());
        this.options.addOption("t", CREATE_KEYSTORE_PARAM, false, SecurityLogger.ROOT_LOGGER.cmdLineAutomaticallyCreateKeystore());
        OptionGroup og = new OptionGroup();
        Option x = new Option("x", SEC_ATTR_VALUE_PARAM, true, SecurityLogger.ROOT_LOGGER.cmdLineSecuredAttribute());
        Option c = new Option("c", CHECK_SEC_ATTR_EXISTS_PARAM, false, SecurityLogger.ROOT_LOGGER.cmdLineCheckAttribute());
        Option r = new Option("r", REMOVE_SEC_ATTR_PARAM, false, SecurityLogger.ROOT_LOGGER.cmdLineRemoveSecuredAttribute());
        Option h = new Option("h", HELP_PARAM, false, SecurityLogger.ROOT_LOGGER.cmdLineHelp());
        og.addOption(x);
        og.addOption(c);
        og.addOption(r);
        og.addOption(h);
        og.setRequired(true);
        this.options.addOptionGroup(og);
    }

    private int execute() throws Exception {
        if (this.cmdLine.hasOption(HELP_PARAM)) {
            this.printUsage();
            return 100;
        }
        String keystoreURL = this.cmdLine.getOptionValue(KEYSTORE_PARAM, "vault.keystore");
        String keystorePassword = this.cmdLine.getOptionValue(KEYSTORE_PASSWORD_PARAM, "");
        String encryptionDirectory = this.cmdLine.getOptionValue(ENC_DIR_PARAM, "vault");
        String salt = this.cmdLine.getOptionValue(SALT_PARAM, "12345678");
        int iterationCount = Integer.parseInt(this.cmdLine.getOptionValue(ITERATION_PARAM, "23"));
        boolean createKeyStore = this.cmdLine.hasOption(CREATE_KEYSTORE_PARAM);
        this.nonInteractiveSession = new VaultSession(keystoreURL, keystorePassword, encryptionDirectory, salt, iterationCount, createKeyStore);
        this.nonInteractiveSession.startVaultSession(this.cmdLine.getOptionValue(ALIAS_PARAM, "vault"));
        String vaultBlock = this.cmdLine.getOptionValue(VAULT_BLOCK_PARAM, "vb");
        String attributeName = this.cmdLine.getOptionValue(ATTRIBUTE_PARAM, "password");
        if (this.cmdLine.hasOption(CHECK_SEC_ATTR_EXISTS_PARAM)) {
            if (this.nonInteractiveSession.checkSecuredAttribute(vaultBlock, attributeName)) {
                System.out.println(SecurityLogger.ROOT_LOGGER.cmdLineSecuredAttributeAlreadyExists());
                return 0;
            }
            System.out.println(SecurityLogger.ROOT_LOGGER.cmdLineSecuredAttributeDoesNotExist());
            return 5;
        }
        if (this.cmdLine.hasOption(REMOVE_SEC_ATTR_PARAM)) {
            if (this.nonInteractiveSession.removeSecuredAttribute(vaultBlock, attributeName)) {
                System.out.println(SecurityLogger.ROOT_LOGGER.messageAttributeRemovedSuccessfuly(VaultSession.blockAttributeDisplayFormat(vaultBlock, attributeName)));
                return 0;
            }
            System.out.println(SecurityLogger.ROOT_LOGGER.messageAttributeNotRemoved(VaultSession.blockAttributeDisplayFormat(vaultBlock, attributeName)));
            return 6;
        }
        if (this.cmdLine.hasOption(SEC_ATTR_VALUE_PARAM)) {
            String password = this.cmdLine.getOptionValue(SEC_ATTR_VALUE_PARAM, "password");
            this.nonInteractiveSession.addSecuredAttributeWithDisplay(vaultBlock, attributeName, password.toCharArray());
            this.summary();
            return 0;
        }
        System.out.println(SecurityLogger.ROOT_LOGGER.actionNotSpecified());
        return -1;
    }

    private void summary() {
        this.nonInteractiveSession.vaultConfigurationDisplay();
    }

    private void printUsage() {
        HelpFormatter help = new HelpFormatter();
        String suffix = VaultTool.isWindows() ? ".bat" : ".sh";
        help.printHelp("vault" + suffix + " <empty> | ", this.options, true);
    }

    public static boolean isWindows() {
        String opsys = System.getProperty("os.name").toLowerCase();
        return opsys.indexOf("win") >= 0;
    }
}

