/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.DuplicateRegistrationException;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.ServiceRegistrationException;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.remote.HttpUpgradeConnectionProviderFactory;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class EndpointCache {
    private static final Logger logger = Logger.getLogger(EndpointCache.class);
    private final ConcurrentMap<CacheKey, CacheEntry> cache = new ConcurrentHashMap<CacheKey, CacheEntry>();

    public synchronized Endpoint get(String endpointName, OptionMap endPointCreationOptions, OptionMap remoteConnectionProviderOptions) throws IOException {
        CacheKey endpointHash = new CacheKey(remoteConnectionProviderOptions, endPointCreationOptions, endpointName);
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(endpointHash);
        if (cacheEntry == null) {
            Endpoint endpoint = Remoting.createEndpoint((String)endpointName, (Xnio)Xnio.getInstance(), (OptionMap)endPointCreationOptions);
            endpoint.addConnectionProvider("remote", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), remoteConnectionProviderOptions);
            endpoint.addConnectionProvider("http-remoting", (ConnectionProviderFactory)new HttpUpgradeConnectionProviderFactory(), OptionMap.builder().addAll(remoteConnectionProviderOptions).set(Options.SSL_ENABLED, (Object)Boolean.FALSE).getMap());
            endpoint.addConnectionProvider("https-remoting", (ConnectionProviderFactory)new HttpUpgradeConnectionProviderFactory(), OptionMap.builder().addAll(remoteConnectionProviderOptions).set(Options.SSL_ENABLED, (Object)Boolean.TRUE).getMap());
            cacheEntry = new CacheEntry(endpoint, new EndpointWrapper(endpointHash, endpoint));
            this.cache.putIfAbsent(endpointHash, cacheEntry);
        }
        cacheEntry.referenceCount.incrementAndGet();
        return cacheEntry.endpointWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(CacheKey endpointHash, boolean async) {
        block7: {
            CacheEntry cacheEntry = (CacheEntry)this.cache.get(endpointHash);
            if (cacheEntry.referenceCount.decrementAndGet() == 0) {
                try {
                    if (async) {
                        cacheEntry.endpoint.closeAsync();
                        break block7;
                    }
                    try {
                        cacheEntry.endpoint.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to close endpoint", e);
                    }
                }
                finally {
                    this.cache.remove(endpointHash);
                }
            }
        }
    }

    public synchronized void shutdown() {
        for (Map.Entry entry : this.cache.entrySet()) {
            EndpointCache.safeClose((Closeable)((CacheEntry)entry.getValue()).endpoint);
        }
    }

    private static void safeClose(Closeable closable) {
        try {
            closable.close();
        }
        catch (Throwable t) {
            logger.debug((Object)"Failed to close endpoint ", t);
        }
    }

    private static class CacheKey {
        final String endpointName;
        final OptionMap connectOptions;
        final OptionMap remoteConnectionProviderOptions;

        private CacheKey(OptionMap remoteConnectionProviderOptions, OptionMap connectOptions, String endpointName) {
            this.remoteConnectionProviderOptions = remoteConnectionProviderOptions;
            this.connectOptions = connectOptions;
            this.endpointName = endpointName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.connectOptions != null ? !this.connectOptions.equals(cacheKey.connectOptions) : cacheKey.connectOptions != null) {
                return false;
            }
            if (this.endpointName != null ? !this.endpointName.equals(cacheKey.endpointName) : cacheKey.endpointName != null) {
                return false;
            }
            return !(this.remoteConnectionProviderOptions != null ? !this.remoteConnectionProviderOptions.equals(cacheKey.remoteConnectionProviderOptions) : cacheKey.remoteConnectionProviderOptions != null);
        }

        public int hashCode() {
            int result = this.endpointName != null ? this.endpointName.hashCode() : 0;
            result = 31 * result + (this.connectOptions != null ? this.connectOptions.hashCode() : 0);
            result = 31 * result + (this.remoteConnectionProviderOptions != null ? this.remoteConnectionProviderOptions.hashCode() : 0);
            return result;
        }
    }

    private static class CacheEntry {
        private final AtomicInteger referenceCount = new AtomicInteger(0);
        private final Endpoint endpoint;
        private final EndpointWrapper endpointWrapper;

        private CacheEntry(Endpoint endpoint, EndpointWrapper endpointWrapper) {
            this.endpoint = endpoint;
            this.endpointWrapper = endpointWrapper;
        }
    }

    private class EndpointWrapper
    implements Endpoint {
        private final CacheKey endpointHash;
        private final Endpoint endpoint;

        private EndpointWrapper(CacheKey endpointHash, Endpoint endpoint) {
            this.endpointHash = endpointHash;
            this.endpoint = endpoint;
        }

        public String getName() {
            return this.endpoint.getName();
        }

        public Registration registerService(String s, OpenListener openListener, OptionMap optionMap) throws ServiceRegistrationException {
            return this.endpoint.registerService(s, openListener, optionMap);
        }

        public IoFuture<Connection> connect(URI uri) throws IOException {
            return this.endpoint.connect(uri);
        }

        public IoFuture<Connection> connect(URI uri, OptionMap optionMap) throws IOException {
            return this.endpoint.connect(uri, optionMap);
        }

        public IoFuture<Connection> connect(URI uri, OptionMap optionMap, CallbackHandler callbackHandler) throws IOException {
            return this.endpoint.connect(uri, optionMap, callbackHandler);
        }

        public IoFuture<Connection> connect(URI uri, OptionMap optionMap, CallbackHandler callbackHandler, SSLContext sslContext) throws IOException {
            return this.endpoint.connect(uri, optionMap, callbackHandler, sslContext);
        }

        public IoFuture<Connection> connect(URI uri, OptionMap optionMap, CallbackHandler callbackHandler, XnioSsl xnioSsl) throws IOException {
            return this.endpoint.connect(uri, optionMap, callbackHandler, xnioSsl);
        }

        public IoFuture<Connection> connect(URI uri, OptionMap optionMap, String s, String s1, char[] chars) throws IOException {
            return this.endpoint.connect(uri, optionMap, s, s1, chars);
        }

        public IoFuture<Connection> connect(URI uri, OptionMap optionMap, String s, String s1, char[] chars, SSLContext sslContext) throws IOException {
            return this.endpoint.connect(uri, optionMap, s, s1, chars, sslContext);
        }

        public IoFuture<Connection> connect(URI uri, OptionMap optionMap, String s, String s1, char[] chars, XnioSsl xnioSsl) throws IOException {
            return this.endpoint.connect(uri, optionMap, s, s1, chars, xnioSsl);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1) throws IOException {
            return this.endpoint.connect(s, socketAddress, socketAddress1);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1, OptionMap optionMap) throws IOException {
            return this.endpoint.connect(s, socketAddress, socketAddress1, optionMap);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1, OptionMap optionMap, CallbackHandler callbackHandler) throws IOException {
            return this.endpoint.connect(s, socketAddress, socketAddress1, optionMap, callbackHandler);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1, OptionMap optionMap, CallbackHandler callbackHandler, SSLContext sslContext) throws IOException {
            return this.endpoint.connect(s, socketAddress, socketAddress1, optionMap, callbackHandler, sslContext);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1, OptionMap optionMap, CallbackHandler callbackHandler, XnioSsl xnioSsl) throws IOException {
            return this.endpoint.connect(s, socketAddress, socketAddress1, optionMap, callbackHandler, xnioSsl);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1, OptionMap optionMap, String s1, String s2, char[] chars) throws IOException {
            return this.endpoint.connect(s, socketAddress, socketAddress1, optionMap, s1, s2, chars);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1, OptionMap optionMap, String s1, String s2, char[] chars, SSLContext sslContext) throws IOException {
            return this.endpoint.connect(s, socketAddress, socketAddress1, optionMap, s1, s2, chars, sslContext);
        }

        public IoFuture<Connection> connect(String s, SocketAddress socketAddress, SocketAddress socketAddress1, OptionMap optionMap, String s1, String s2, char[] chars, XnioSsl xnioSsl) throws IOException {
            return this.endpoint.connect(s, socketAddress, socketAddress1, optionMap, s1, s2, chars, xnioSsl);
        }

        public Registration addConnectionProvider(String s, ConnectionProviderFactory connectionProviderFactory, OptionMap optionMap) throws DuplicateRegistrationException, IOException {
            return this.endpoint.addConnectionProvider(s, connectionProviderFactory, optionMap);
        }

        public <T> T getConnectionProviderInterface(String s, Class<T> tClass) throws UnknownURISchemeException, ClassCastException {
            return (T)this.endpoint.getConnectionProviderInterface(s, tClass);
        }

        public boolean isValidUriScheme(String s) {
            return this.endpoint.isValidUriScheme(s);
        }

        public XnioWorker getXnioWorker() {
            return this.endpoint.getXnioWorker();
        }

        public void close() throws IOException {
            EndpointCache.this.release(this.endpointHash, false);
        }

        public void awaitClosed() throws InterruptedException {
            this.endpoint.awaitClosed();
        }

        public void awaitClosedUninterruptibly() {
            this.endpoint.awaitClosedUninterruptibly();
        }

        public void closeAsync() {
            EndpointCache.this.release(this.endpointHash, true);
        }

        public HandleableCloseable.Key addCloseHandler(CloseHandler<? super Endpoint> closeHandler) {
            return this.endpoint.addCloseHandler(closeHandler);
        }

        public Attachments getAttachments() {
            return this.endpoint.getAttachments();
        }
    }
}

