/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.QueueAdd;
import org.wildfly.extension.messaging.activemq.QueueControlHandler;
import org.wildfly.extension.messaging.activemq.QueueReadAttributeHandler;
import org.wildfly.extension.messaging.activemq.QueueRemove;

public class QueueDefinition
extends PersistentResourceDefinition {
    public static final SimpleAttributeDefinition ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"queue-address", (ModelType)ModelType.STRING).setXmlName("address")).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{ADDRESS, CommonAttributes.FILTER, CommonAttributes.DURABLE};
    public static final SimpleAttributeDefinition EXPIRY_ADDRESS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.EXPIRY_ADDRESS).setStorageRuntime()).build();
    public static final SimpleAttributeDefinition DEAD_LETTER_ADDRESS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.DEAD_LETTER_ADDRESS).setStorageRuntime()).build();
    static final AttributeDefinition ID = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"id", (ModelType)ModelType.LONG).setStorageRuntime()).build();
    static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.PAUSED, CommonAttributes.TEMPORARY, ID, DEAD_LETTER_ADDRESS, EXPIRY_ADDRESS};
    static final AttributeDefinition[] METRICS = new AttributeDefinition[]{CommonAttributes.MESSAGE_COUNT, CommonAttributes.DELIVERING_COUNT, CommonAttributes.MESSAGES_ADDED, CommonAttributes.SCHEDULED_COUNT, CommonAttributes.CONSUMER_COUNT};
    static final QueueDefinition INSTANCE = new QueueDefinition(false, MessagingExtension.QUEUE_PATH);
    static final QueueDefinition RUNTIME_INSTANCE = new QueueDefinition(true, MessagingExtension.RUNTIME_QUEUE_PATH);
    private final boolean runtimeOnly;

    private QueueDefinition(boolean runtimeOnly, PathElement path) {
        super(path, MessagingExtension.getResourceDescriptionResolver("queue"), (OperationStepHandler)(runtimeOnly ? null : QueueAdd.INSTANCE), (OperationStepHandler)(runtimeOnly ? null : QueueRemove.INSTANCE), runtimeOnly);
        this.runtimeOnly = runtimeOnly;
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        for (SimpleAttributeDefinition simpleAttributeDefinition : ATTRIBUTES) {
            if (simpleAttributeDefinition.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            if (this.runtimeOnly) {
                SimpleAttributeDefinition readOnlyRuntimeAttr = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)simpleAttributeDefinition).setStorageRuntime()).build();
                registry.registerReadOnlyAttribute((AttributeDefinition)readOnlyRuntimeAttr, (OperationStepHandler)QueueReadAttributeHandler.RUNTIME_INSTANCE);
                continue;
            }
            registry.registerReadOnlyAttribute((AttributeDefinition)simpleAttributeDefinition, null);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : READONLY_ATTRIBUTES) {
            registry.registerReadOnlyAttribute((AttributeDefinition)simpleAttributeDefinition, (OperationStepHandler)QueueReadAttributeHandler.INSTANCE);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : METRICS) {
            registry.registerMetric((AttributeDefinition)simpleAttributeDefinition, (OperationStepHandler)QueueReadAttributeHandler.INSTANCE);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Collections.emptyList();
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        QueueControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        if (this.runtimeOnly) {
            return Collections.emptyList();
        }
        return Arrays.asList(MessagingExtension.QUEUE_ACCESS_CONSTRAINT);
    }

    static boolean forwardToRuntimeQueue(OperationContext context, ModelNode operation, OperationStepHandler handler) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        if ("runtime-queue".equals(address.getLastElement().getKey())) {
            return false;
        }
        String queueName = address.getLastElement().getValue();
        PathAddress activeMQPathAddress = MessagingServices.getActiveMQServerPathAddress(address);
        Resource serverResource = context.readResourceFromRoot(activeMQPathAddress);
        boolean hasChild = serverResource.hasChild(address.getLastElement());
        if (hasChild) {
            return false;
        }
        ModelNode forwardOperation = operation.clone();
        forwardOperation.get("address").set(activeMQPathAddress.append("runtime-queue", queueName).toModelNode());
        context.addStep(forwardOperation, handler, OperationContext.Stage.RUNTIME, true);
        return true;
    }
}

