/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.deployment.BeanDeploymentArchiveImpl;
import org.jboss.as.weld.deployment.WeldEEModuleDescriptor;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.EEModuleDescriptor;

public class BeanDeploymentModule {
    private final Set<BeanDeploymentArchiveImpl> beanDeploymentArchives;
    private final EEModuleDescriptor moduleDescriptor;

    public BeanDeploymentModule(String moduleId, DeploymentUnit deploymentUnit, Collection<BeanDeploymentArchiveImpl> beanDeploymentArchives) {
        this.beanDeploymentArchives = ImmutableSet.copyOf(beanDeploymentArchives);
        for (BeanDeploymentArchiveImpl bda : beanDeploymentArchives) {
            bda.addBeanDeploymentArchives(beanDeploymentArchives);
        }
        this.moduleDescriptor = WeldEEModuleDescriptor.of(moduleId, deploymentUnit);
        if (this.moduleDescriptor != null) {
            this.addService(EEModuleDescriptor.class, this.moduleDescriptor);
        }
    }

    public synchronized void addBeanDeploymentArchive(BeanDeploymentArchiveImpl archive) {
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            bda.addBeanDeploymentArchive(archive);
        }
    }

    public synchronized void addBeanDeploymentModule(BeanDeploymentModule module) {
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            bda.addBeanDeploymentArchives(module.beanDeploymentArchives);
        }
    }

    public synchronized void addBeanDeploymentModules(Collection<BeanDeploymentModule> modules) {
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            for (BeanDeploymentModule bdm : modules) {
                bda.addBeanDeploymentArchives(bdm.beanDeploymentArchives);
            }
        }
    }

    public synchronized <S extends Service> void addService(Class<S> clazz, S service) {
        for (BeanDeploymentArchiveImpl bda : this.beanDeploymentArchives) {
            bda.getServices().add(clazz, service);
        }
    }

    public Set<BeanDeploymentArchiveImpl> getBeanDeploymentArchives() {
        return this.beanDeploymentArchives;
    }

    public EEModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }
}

