/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.io.Serializable;
import java.security.AccessController;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.context.ejb.EjbRequestContext;
import org.jboss.weld.ejb.AbstractEJBRequestScopeActivationInterceptor;
import org.jboss.weld.manager.BeanManagerImpl;

public class EjbRequestScopeActivationInterceptor
extends AbstractEJBRequestScopeActivationInterceptor
implements Serializable,
Interceptor {
    private static final long serialVersionUID = -503029523442133584L;
    private volatile EjbRequestContext requestContext;
    private volatile BeanManagerImpl beanManager;
    private final ServiceName weldContainerServiceName;

    public EjbRequestScopeActivationInterceptor(ServiceName weldContainerServiceName) {
        this.weldContainerServiceName = weldContainerServiceName;
    }

    protected BeanManagerImpl getBeanManager() {
        if (this.beanManager == null) {
            WeldBootstrapService weldContainer = (WeldBootstrapService)EjbRequestScopeActivationInterceptor.currentServiceContainer().getRequiredService(this.weldContainerServiceName).getValue();
            this.beanManager = weldContainer.getBeanManager();
        }
        return this.beanManager;
    }

    protected EjbRequestContext getEjbRequestContext() {
        if (this.requestContext == null) {
            this.requestContext = super.getEjbRequestContext();
        }
        return this.requestContext;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        return this.aroundInvoke(context.getInvocationContext());
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    public static class Factory
    implements InterceptorFactory {
        private final Interceptor interceptor;

        public Factory(ServiceName weldContainerServiceName) {
            this.interceptor = new EjbRequestScopeActivationInterceptor(weldContainerServiceName);
        }

        public Interceptor create(InterceptorFactoryContext context) {
            return this.interceptor;
        }
    }
}

