/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.platform.mbean.CommonAttributes;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class PlatformLoggingMXBeanSetLoggerLevelHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("set-logger-level", (ResourceDescriptionResolver)PlatformMBeanUtil.getResolver("threading")).setParameters(new AttributeDefinition[]{CommonAttributes.LOGGER_NAME, CommonAttributes.LEVEL_NAME}).setRuntimeOnly().setReadOnly().build();
    public static final PlatformLoggingMXBeanSetLoggerLevelHandler INSTANCE = new PlatformLoggingMXBeanSetLoggerLevelHandler();
    private static final String[] GET_LOGGER_LEVEL_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] SET_LOGGER_LEVEL_SIGNATURE = new String[]{String.class.getName(), String.class.getName()};
    private final ParametersValidator parametersValidator = new ParametersValidator();

    private PlatformLoggingMXBeanSetLoggerLevelHandler() {
        this.parametersValidator.registerValidator("logger-name", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, false, false));
        this.parametersValidator.registerValidator("level-name", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true, false));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String priorLevel;
        this.parametersValidator.validate(operation);
        final String loggerName = operation.require("logger-name").asString();
        String levelName = operation.hasDefined("level-name") ? operation.require("level-name").asString() : null;
        try {
            priorLevel = (String)ManagementFactory.getPlatformMBeanServer().invoke(PlatformMBeanConstants.PLATFORM_LOGGING_OBJECT_NAME, "getLoggerLevel", new String[]{loggerName}, GET_LOGGER_LEVEL_SIGNATURE);
            ManagementFactory.getPlatformMBeanServer().invoke(PlatformMBeanConstants.PLATFORM_LOGGING_OBJECT_NAME, "setLoggerLevel", new String[]{loggerName, levelName}, SET_LOGGER_LEVEL_SIGNATURE);
            context.getResult();
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                try {
                    ManagementFactory.getPlatformMBeanServer().invoke(PlatformMBeanConstants.PLATFORM_LOGGING_OBJECT_NAME, "setLoggerLevel", new String[]{loggerName, priorLevel}, SET_LOGGER_LEVEL_SIGNATURE);
                }
                catch (JMRuntimeException e) {
                    throw e;
                }
                catch (JMException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

