/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.UndertowOptions;
import java.util.Collection;
import java.util.LinkedList;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.wildfly.extension.undertow.HttpsListenerAdd;
import org.wildfly.extension.undertow.ListenerAdd;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.UndertowExtension;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;

public class HttpsListenerResourceDefinition
extends ListenerResourceDefinition {
    protected static final HttpsListenerResourceDefinition INSTANCE = new HttpsListenerResourceDefinition();
    protected static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING).setAllowNull(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SECURITY_REALM_REF})).build();
    protected static final OptionAttributeDefinition VERIFY_CLIENT = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"verify-client", (Option)Options.SSL_CLIENT_AUTH_MODE).setAllowNull(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setValidator((ParameterValidator)new EnumValidator(SslClientAuthMode.class, true, true))).setDefaultValue(new ModelNode(SslClientAuthMode.NOT_REQUESTED.name()))).build();
    protected static final OptionAttributeDefinition ENABLED_CIPHER_SUITES = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"enabled-cipher-suites", (Option)Options.SSL_ENABLED_CIPHER_SUITES).setAllowNull(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    protected static final OptionAttributeDefinition ENABLED_PROTOCOLS = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"enabled-protocols", (Option)Options.SSL_ENABLED_PROTOCOLS).setAllowNull(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
    protected static final OptionAttributeDefinition ENABLE_HTTP2 = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"enable-http2", (Option)UndertowOptions.ENABLE_HTTP2).setAllowNull(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    protected static final OptionAttributeDefinition ENABLE_SPDY = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"enable-spdy", (Option)UndertowOptions.ENABLE_SPDY).setAllowNull(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    public static final OptionAttributeDefinition SSL_SESSION_CACHE_SIZE = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"ssl-session-cache-size", (Option)Options.SSL_SERVER_SESSION_CACHE_SIZE).setAllowNull(true)).setAllowExpression(true)).build();
    public static final OptionAttributeDefinition SSL_SESSION_TIMEOUT = ((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)"ssl-session-timeout", (Option)Options.SSL_SERVER_SESSION_TIMEOUT).setMeasurementUnit(MeasurementUnit.SECONDS)).setAllowNull(true)).setAllowExpression(true)).build();

    private HttpsListenerResourceDefinition() {
        super(UndertowExtension.HTTPS_LISTENER_PATH);
    }

    @Override
    public Collection<AttributeDefinition> getAttributes() {
        LinkedList<AttributeDefinition> res = new LinkedList<AttributeDefinition>(super.getAttributes());
        res.add((AttributeDefinition)SECURITY_REALM);
        res.add((AttributeDefinition)VERIFY_CLIENT);
        res.add((AttributeDefinition)ENABLED_CIPHER_SUITES);
        res.add((AttributeDefinition)ENABLED_PROTOCOLS);
        res.add((AttributeDefinition)ENABLE_HTTP2);
        res.add((AttributeDefinition)ENABLE_SPDY);
        res.add((AttributeDefinition)SSL_SESSION_CACHE_SIZE);
        res.add((AttributeDefinition)SSL_SESSION_TIMEOUT);
        return res;
    }

    @Override
    protected ListenerAdd getAddHandler() {
        return new HttpsListenerAdd(this);
    }
}

