/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.jaspi;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.AttachmentKey;
import java.security.Principal;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.MessageInfo;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.security.auth.callback.JASPICallbackHandler;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.auth.message.GenericMessageInfo;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.plugins.auth.JASPIServerAuthenticationManager;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.security.AccountImpl;
import org.wildfly.extension.undertow.security.UndertowSecurityAttachments;
import org.wildfly.extension.undertow.security.jaspi.JASPICContext;
import org.wildfly.extension.undertow.security.jaspi.JASPICSecurityContext;
import org.wildfly.extension.undertow.security.jaspi.SecurityActions;

public class JASPICAuthenticationMechanism
implements AuthenticationMechanism {
    static final String JASPI_HTTP_SERVLET_LAYER = "HttpServlet";
    private static final String MECHANISM_NAME = "JASPIC";
    private static final String JASPI_AUTH_TYPE = "javax.servlet.http.authType";
    private static final String JASPI_REGISTER_SESSION = "javax.servlet.http.registerSession";
    public static final AttachmentKey<HttpServerExchange> HTTP_SERVER_EXCHANGE_ATTACHMENT_KEY = AttachmentKey.create(HttpServerExchange.class);
    public static final AttachmentKey<SecurityContext> SECURITY_CONTEXT_ATTACHMENT_KEY = AttachmentKey.create(SecurityContext.class);
    public static final AttachmentKey<Boolean> AUTH_RUN = AttachmentKey.create(Boolean.class);
    public static final int DEFAULT_ERROR_CODE = 401;
    private final String securityDomain;
    private final String configuredAuthMethod;

    public JASPICAuthenticationMechanism(String securityDomain, String configuredAuthMethod) {
        this.securityDomain = securityDomain;
        this.configuredAuthMethod = configuredAuthMethod;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext sc) {
        String authType;
        AuthenticatedSessionManager.AuthenticatedSession authSession;
        exchange.putAttachment(AUTH_RUN, (Object)true);
        ServletRequestContext requestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        JASPIServerAuthenticationManager sam = this.createJASPIAuthenticationManager();
        GenericMessageInfo messageInfo = this.createMessageInfo(exchange, sc);
        String applicationIdentifier = JASPICAuthenticationMechanism.buildApplicationIdentifier(requestContext);
        JASPICallbackHandler cbh = new JASPICallbackHandler();
        exchange.putAttachment(JASPICContext.ATTACHMENT_KEY, (Object)new JASPICContext((MessageInfo)messageInfo, sam, cbh));
        UndertowLogger.ROOT_LOGGER.debugf("validateRequest for layer [%s] and applicationContextIdentifier [%s]", JASPI_HTTP_SERVLET_LAYER, applicationIdentifier);
        Account cachedAccount = null;
        JASPICSecurityContext jaspicSecurityContext = (JASPICSecurityContext)exchange.getSecurityContext();
        AuthenticatedSessionManager sessionManager = (AuthenticatedSessionManager)exchange.getAttachment(AuthenticatedSessionManager.ATTACHMENT_KEY);
        if (sessionManager != null && (authSession = sessionManager.lookupSession(exchange)) != null && (cachedAccount = authSession.getAccount()) != null) {
            jaspicSecurityContext.setCachedAuthenticatedAccount(cachedAccount);
        }
        AuthenticationMechanism.AuthenticationMechanismOutcome outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        Account authenticatedAccount = null;
        boolean isValid = sam.isValid((MessageInfo)messageInfo, new Subject(), JASPI_HTTP_SERVLET_LAYER, applicationIdentifier, (CallbackHandler)cbh);
        jaspicSecurityContext.setCachedAuthenticatedAccount(null);
        if (isValid) {
            org.jboss.security.SecurityContext jbossSct = SecurityActions.getSecurityContext();
            authenticatedAccount = this.createAccount(cachedAccount, jbossSct);
        }
        if ((authType = (String)messageInfo.getMap().get(JASPI_AUTH_TYPE)) == null) {
            String string = authType = this.configuredAuthMethod != null ? this.configuredAuthMethod : MECHANISM_NAME;
        }
        if (isValid && authenticatedAccount != null) {
            outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
            Object registerObj = messageInfo.getMap().get(JASPI_REGISTER_SESSION);
            boolean cache = false;
            if (registerObj != null && registerObj instanceof String) {
                cache = Boolean.valueOf((String)registerObj);
            }
            sc.authenticationComplete(authenticatedAccount, authType, cache);
        } else if (isValid && authenticatedAccount == null && !this.isMandatory(requestContext).booleanValue()) {
            outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        } else {
            outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            sc.authenticationFailed("JASPIC authentication failed.", authType);
            if (JASPICAuthenticationMechanism.wasAuthExceptionThrown(exchange) && !this.statusIndicatesError(exchange)) {
                exchange.setResponseCode(401);
            }
        }
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        servletRequestContext.setServletRequest((ServletRequest)((HttpServletRequest)messageInfo.getRequestMessage()));
        servletRequestContext.setServletResponse((ServletResponse)((HttpServletResponse)messageInfo.getResponseMessage()));
        return outcome;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(true);
    }

    private JASPIServerAuthenticationManager createJASPIAuthenticationManager() {
        return new JASPIServerAuthenticationManager(this.securityDomain, (CallbackHandler)new JBossCallbackHandler());
    }

    static String buildApplicationIdentifier(ServletRequestContext attachment) {
        ServletRequest servletRequest = attachment.getServletRequest();
        return servletRequest.getServletContext().getVirtualServerName() + " " + servletRequest.getServletContext().getContextPath();
    }

    private GenericMessageInfo createMessageInfo(HttpServerExchange exchange, SecurityContext securityContext) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        GenericMessageInfo messageInfo = new GenericMessageInfo();
        messageInfo.setRequestMessage((Object)servletRequestContext.getServletRequest());
        messageInfo.setResponseMessage((Object)servletRequestContext.getServletResponse());
        messageInfo.getMap().put("javax.security.auth.message.MessagePolicy.isMandatory", this.isMandatory(servletRequestContext).toString());
        messageInfo.getMap().put(SECURITY_CONTEXT_ATTACHMENT_KEY, securityContext);
        messageInfo.getMap().put(HTTP_SERVER_EXCHANGE_ATTACHMENT_KEY, exchange);
        return messageInfo;
    }

    private Account createAccount(Account cachedAccount, org.jboss.security.SecurityContext jbossSct) {
        if (jbossSct == null) {
            throw UndertowLogger.ROOT_LOGGER.nullParamter("org.jboss.security.SecurityContext");
        }
        Principal userPrincipal = jbossSct.getUtil().getUserPrincipal();
        if (userPrincipal == null) {
            return null;
        }
        if (cachedAccount != null && cachedAccount.getPrincipal() == userPrincipal) {
            jbossSct.getUtil().createSubjectInfo(userPrincipal, ((AccountImpl)cachedAccount).getCredential(), null);
            SimpleRoleGroup roleGroup = new SimpleRoleGroup("Roles");
            for (String role : cachedAccount.getRoles()) {
                roleGroup.addRole((Role)new SimpleRole(role));
            }
            jbossSct.getUtil().setRoles((RoleGroup)roleGroup);
            return cachedAccount;
        }
        HashSet<String> stringRoles = new HashSet<String>();
        RoleGroup roleGroup = jbossSct.getUtil().getRoles();
        if (roleGroup != null) {
            for (Role role : roleGroup.getRoles()) {
                stringRoles.add(role.getRoleName());
            }
        }
        Object credential = jbossSct.getUtil().getCredential();
        Principal original = null;
        if (cachedAccount != null) {
            original = cachedAccount.getPrincipal();
        }
        return new AccountImpl(userPrincipal, stringRoles, credential, original);
    }

    private Boolean isMandatory(ServletRequestContext attachment) {
        return attachment.getExchange().getSecurityContext() != null && attachment.getExchange().getSecurityContext().isAuthenticationRequired();
    }

    private boolean statusIndicatesError(HttpServerExchange exchange) {
        return exchange.getResponseCode() != 200;
    }

    static boolean wasAuthExceptionThrown(HttpServerExchange exchange) {
        return ((org.jboss.security.SecurityContext)exchange.getAttachment(UndertowSecurityAttachments.SECURITY_CONTEXT_ATTACHMENT)).getData().get(AuthException.class.getName()) != null;
    }
}

