/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.j2ee;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.PublishLocationAdapter;

public class EJBArchiveMetaData {
    private final List<EJBMetaData> beans;
    private final String configName;
    private final String configFile;
    private final String webServiceContextRoot;
    private final String securityDomain;
    private final PublishLocationAdapter publishLocationAdapter;

    public EJBArchiveMetaData(List<EJBMetaData> beans, String configName, String configFile, String webServiceContextRoot, String securityDomain, PublishLocationAdapter publishLocationAdapter) {
        this.beans = beans != null && !beans.isEmpty() ? Collections.unmodifiableList(beans) : Collections.emptyList();
        this.configName = configName;
        this.configFile = configFile;
        this.webServiceContextRoot = webServiceContextRoot;
        this.securityDomain = securityDomain;
        this.publishLocationAdapter = publishLocationAdapter;
    }

    public EJBMetaData getBeanByEjbName(String ejbName) {
        for (EJBMetaData beanMetaData : this.beans) {
            if (!beanMetaData.getEjbName().equals(ejbName)) continue;
            return beanMetaData;
        }
        return null;
    }

    public Iterator<EJBMetaData> getEnterpriseBeans() {
        return this.beans.iterator();
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getWebServiceContextRoot() {
        return this.webServiceContextRoot;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public String getWsdlPublishLocationByName(String name) {
        if (this.publishLocationAdapter != null) {
            return this.publishLocationAdapter.getWsdlPublishLocationByName(name);
        }
        return null;
    }

    public static class Builder {
        private List<EJBMetaData> beans = Collections.emptyList();
        private String configName;
        private String configFile;
        private String webServiceContextRoot;
        private String securityDomain;
        private PublishLocationAdapter publishLocationAdapter;

        public EJBArchiveMetaData build() {
            return new EJBArchiveMetaData(this.beans, this.configName, this.configFile, this.webServiceContextRoot, this.securityDomain, this.publishLocationAdapter);
        }

        public List<EJBMetaData> getEnterpriseBeans() {
            return this.beans;
        }

        public void setEnterpriseBeans(List<EJBMetaData> beans) {
            this.beans = beans;
        }

        public String getConfigName() {
            return this.configName;
        }

        public void setConfigName(String configName) {
            this.configName = configName;
        }

        public String getConfigFile() {
            return this.configFile;
        }

        public void setConfigFile(String configFile) {
            this.configFile = configFile;
        }

        public String getWebServiceContextRoot() {
            return this.webServiceContextRoot;
        }

        public void setWebServiceContextRoot(String webServiceContextRoot) {
            this.webServiceContextRoot = webServiceContextRoot;
        }

        public String getSecurityDomain() {
            return this.securityDomain;
        }

        public void setSecurityDomain(String securityDomain) {
            this.securityDomain = securityDomain;
        }

        public PublishLocationAdapter getPublishLocationAdapter() {
            return this.publishLocationAdapter;
        }

        public void setPublishLocationAdapter(PublishLocationAdapter publishLocationAdapter) {
            this.publishLocationAdapter = publishLocationAdapter;
        }
    }
}

