/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.clustering.singleton.SimpleElectionPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonResourceDefinition;

public enum XMLAttribute {
    CACHE(SingletonPolicyResourceDefinition.Attribute.CACHE),
    CACHE_CONTAINER(SingletonPolicyResourceDefinition.Attribute.CACHE_CONTAINER),
    DEFAULT(SingletonResourceDefinition.Attribute.DEFAULT),
    NAME("name"),
    POSITION(SimpleElectionPolicyResourceDefinition.Attribute.POSITION),
    QUORUM(SingletonPolicyResourceDefinition.Attribute.QUORUM);

    private final String localName;
    private static final Map<String, XMLAttribute> map;

    private XMLAttribute(Attribute attribute) {
        this(((AttributeDefinition)attribute.getDefinition()).getXmlName());
    }

    private XMLAttribute(String localName) {
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String require(XMLExtendedStreamReader reader) throws XMLStreamException {
        String value = reader.getAttributeValue(null, this.localName);
        if (value == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{this.localName});
        }
        return value;
    }

    static XMLAttribute forName(XMLExtendedStreamReader reader, int index) throws XMLStreamException {
        XMLAttribute attribute = map.get(reader.getAttributeLocalName(index));
        if (attribute == null) {
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
        }
        return attribute;
    }

    static {
        map = new HashMap<String, XMLAttribute>();
        for (XMLAttribute attribute : XMLAttribute.values()) {
            map.put(attribute.getLocalName(), attribute);
        }
    }
}

