/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability.registry;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.registry.CapabilityId;
import org.jboss.as.controller.capability.registry.CapabilityScope;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.capability.registry.RuntimeRequirementRegistration;

public class RequirementRegistration {
    private final Map<PathAddress, RegistrationPoint> registrationPoints = new LinkedHashMap<PathAddress, RegistrationPoint>();
    private final String requiredName;
    private final CapabilityId dependentId;

    public RequirementRegistration(String requiredName, String dependentName, CapabilityScope dependentContext) {
        this(requiredName, new CapabilityId(dependentName, dependentContext));
    }

    protected RequirementRegistration(String requiredName, CapabilityId dependentId) {
        this.requiredName = requiredName;
        this.dependentId = dependentId;
    }

    protected RequirementRegistration(String requiredName, String dependentName, CapabilityScope dependentContext, RegistrationPoint registrationPoint) {
        this(requiredName, dependentName, dependentContext);
        this.registrationPoints.put(registrationPoint.getAddress(), registrationPoint);
    }

    public RequirementRegistration(RuntimeRequirementRegistration toCopy) {
        this(toCopy.getRequiredName(), toCopy.getDependentId());
        this.registrationPoints.putAll(toCopy.registrationPoints);
    }

    public String getRequiredName() {
        return this.requiredName;
    }

    public String getDependentName() {
        return this.dependentId.getName();
    }

    public CapabilityScope getDependentContext() {
        return this.dependentId.getScope();
    }

    public CapabilityId getDependentId() {
        return this.dependentId;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        RequirementRegistration that = (RequirementRegistration)o;
        return this.dependentId.equals(that.dependentId) && this.requiredName.equals(that.requiredName);
    }

    public final int hashCode() {
        int result = this.requiredName.hashCode();
        result = 31 * result + this.dependentId.hashCode();
        return result;
    }

    public synchronized RegistrationPoint getOldestRegistrationPoint() {
        return this.registrationPoints.size() == 0 ? null : this.registrationPoints.values().iterator().next();
    }

    public synchronized Set<RegistrationPoint> getRegistrationPoints() {
        return Collections.unmodifiableSet(new HashSet<RegistrationPoint>(this.registrationPoints.values()));
    }

    public synchronized boolean addRegistrationPoint(RegistrationPoint toAdd) {
        PathAddress addedAddress = toAdd.getAddress();
        if (this.registrationPoints.containsKey(addedAddress)) {
            return false;
        }
        this.registrationPoints.put(addedAddress, toAdd);
        return true;
    }

    public synchronized boolean removeRegistrationPoint(RegistrationPoint toAdd) {
        PathAddress addedAddress = toAdd.getAddress();
        if (!this.registrationPoints.containsKey(addedAddress)) {
            return false;
        }
        this.registrationPoints.remove(addedAddress);
        return true;
    }

    public synchronized int getRegistrationPointCount() {
        return this.registrationPoints.size();
    }
}

