/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version07;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.protocol.framed.SendFrameHeader;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.core.protocol.version07.Masker;
import io.undertow.websockets.core.protocol.version07.WebSocket07Channel;
import io.undertow.websockets.extensions.ExtensionFunction;
import io.undertow.websockets.extensions.NoopExtensionFunction;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;

public abstract class WebSocket07FrameSinkChannel
extends StreamSinkFrameChannel {
    private final Masker masker;
    private volatile boolean dataWritten = false;
    protected final ExtensionFunction extensionFunction;

    protected WebSocket07FrameSinkChannel(WebSocket07Channel wsChannel, WebSocketFrameType type) {
        super(wsChannel, type);
        this.masker = wsChannel.isClient() ? new Masker(0) : null;
        if (wsChannel.areExtensionsSupported() && (type == WebSocketFrameType.TEXT || type == WebSocketFrameType.BINARY)) {
            this.extensionFunction = wsChannel.getExtensionFunction();
            this.setRsv(this.extensionFunction.writeRsv(0));
        } else {
            this.extensionFunction = NoopExtensionFunction.instance;
            this.setRsv(0);
        }
    }

    @Override
    protected void handleFlushComplete(boolean finalFrame) {
        this.dataWritten = true;
    }

    private byte opCode() {
        if (this.dataWritten) {
            return 0;
        }
        switch (this.getType()) {
            case CONTINUATION: {
                return 0;
            }
            case TEXT: {
                return 1;
            }
            case BINARY: {
                return 2;
            }
            case CLOSE: {
                return 8;
            }
            case PING: {
                return 9;
            }
            case PONG: {
                return 10;
            }
        }
        throw WebSocketMessages.MESSAGES.unsupportedFrameType(this.getType());
    }

    @Override
    protected SendFrameHeader createFrameHeader() {
        long payloadSize;
        byte opCode;
        PooledByteBuffer start = ((WebSocketChannel)this.getChannel()).getBufferPool().allocate();
        byte b0 = 0;
        if (this.isFinalFrameQueued()) {
            b0 = (byte)(b0 | 0x80);
        }
        int rsv = (opCode = this.opCode()) == 0 ? 0 : this.getRsv();
        b0 = (byte)(b0 | (rsv & 7) << 4);
        b0 = (byte)(b0 | opCode & 0xF);
        ByteBuffer header = start.getBuffer();
        int maskKey = 0;
        if (this.masker != null) {
            maskKey = (byte)(maskKey | 0x80);
        }
        if ((payloadSize = (long)this.getBuffer().remaining()) > 125L && opCode == 9) {
            throw WebSocketMessages.MESSAGES.invalidPayloadLengthForPing(payloadSize);
        }
        if (payloadSize <= 125L) {
            header.put(b0);
            header.put((byte)((payloadSize | (long)maskKey) & 0xFFL));
        } else if (payloadSize <= 65535L) {
            header.put(b0);
            header.put((byte)((0x7E | maskKey) & 0xFF));
            header.put((byte)(payloadSize >>> 8 & 0xFFL));
            header.put((byte)(payloadSize & 0xFFL));
        } else {
            header.put(b0);
            header.put((byte)((0x7F | maskKey) & 0xFF));
            header.putLong(payloadSize);
        }
        if (this.masker != null) {
            int maskingKey = new Random().nextInt();
            header.put((byte)(maskingKey >> 24 & 0xFF));
            header.put((byte)(maskingKey >> 16 & 0xFF));
            header.put((byte)(maskingKey >> 8 & 0xFF));
            header.put((byte)(maskingKey & 0xFF));
            this.masker.setMaskingKey(maskingKey);
            ByteBuffer buf = this.getBuffer();
            this.masker.beforeWrite(buf, buf.position(), buf.remaining());
        }
        header.flip();
        return new SendFrameHeader(0, start);
    }

    @Override
    public boolean sendInternal(PooledByteBuffer pooled) throws IOException {
        if (this.safeToSend()) {
            return super.sendInternal(this.extensionFunction.transformForWrite(pooled, this.getWebSocketChannel()));
        }
        return false;
    }
}

