/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.messaging;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.config.SAMLConfigurationSupport;
import org.opensaml.security.SecurityException;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureSupport;

public final class SAMLMessageSecuritySupport {
    private SAMLMessageSecuritySupport() {
    }

    public static void signMessage(@Nonnull MessageContext<SAMLObject> messageContext) throws SecurityException, MarshallingException, SignatureException {
        Constraint.isNotNull(messageContext, (String)"Message context cannot be null");
        SAMLObject outboundSAML = (SAMLObject)messageContext.getMessage();
        SignatureSigningParameters parameters = SAMLMessageSecuritySupport.getContextSigningParameters(messageContext);
        if (outboundSAML instanceof SignableXMLObject && parameters != null) {
            SignatureSupport.signObject((SignableXMLObject)((SignableXMLObject)outboundSAML), (SignatureSigningParameters)parameters);
        }
    }

    @Nullable
    public static SignatureSigningParameters getContextSigningParameters(@Nonnull MessageContext<SAMLObject> messageContext) {
        Constraint.isNotNull(messageContext, (String)"Message context cannot be null");
        SecurityParametersContext context = (SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class);
        if (context != null) {
            return context.getSignatureSigningParameters();
        }
        return null;
    }

    public static boolean checkURLScheme(@Nonnull @NotEmpty String scheme) {
        return SAMLConfigurationSupport.getAllowedBindingURLSchemes().contains(scheme);
    }
}

