/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.qourum;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.cluster.qourum.BooleanVote;
import org.apache.activemq.artemis.core.server.cluster.qourum.QuorumVote;
import org.apache.activemq.artemis.core.server.cluster.qourum.Vote;

public class QuorumVoteServerConnect
extends QuorumVote<BooleanVote, Boolean> {
    private static final SimpleString LIVE_FAILOVER_VOTE = new SimpleString("LIVE_FAILOVER)VOTE");
    private final CountDownLatch latch;
    private double votesNeeded;
    private int total = 0;
    private boolean decision = false;

    public QuorumVoteServerConnect(int size, StorageManager storageManager) {
        super(LIVE_FAILOVER_VOTE);
        int actualSize = size - 1;
        this.votesNeeded = actualSize <= 2 ? (double)(actualSize / 2) : (double)(actualSize / 2 + 1);
        int latchSize = this.votesNeeded > (double)((int)this.votesNeeded) ? (int)this.votesNeeded + 1 : (int)this.votesNeeded;
        this.latch = new CountDownLatch(latchSize);
        if (this.votesNeeded == 0.0) {
            this.decision = true;
        }
    }

    @Override
    public Vote connected() {
        return new BooleanVote(true);
    }

    @Override
    public Vote notConnected() {
        return new BooleanVote(false);
    }

    @Override
    public synchronized void vote(BooleanVote vote) {
        if (this.decision) {
            return;
        }
        if (vote.getVote().booleanValue()) {
            ++this.total;
            if ((double)this.total >= this.votesNeeded) {
                this.decision = true;
                this.latch.countDown();
            }
        }
    }

    @Override
    public void allVotesCast(Topology voteTopology) {
    }

    @Override
    public Boolean getDecision() {
        return this.decision;
    }

    @Override
    public SimpleString getName() {
        return null;
    }

    public void await(int latchTimeout, TimeUnit unit) throws InterruptedException {
        this.latch.await(latchTimeout, unit);
    }
}

