/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distribution.ch.ConsistentHashFactory;

public class CacheJoinInfo {
    private final ConsistentHashFactory consistentHashFactory;
    private final Hash hashFunction;
    private final int numSegments;
    private final int numOwners;
    private final long timeout;
    private final boolean totalOrder;
    private final boolean distributed;
    private final float capacityFactor;

    public CacheJoinInfo(ConsistentHashFactory consistentHashFactory, Hash hashFunction, int numSegments, int numOwners, long timeout, boolean totalOrder, boolean distributed, float capacityFactor) {
        this.consistentHashFactory = consistentHashFactory;
        this.hashFunction = hashFunction;
        this.numSegments = numSegments;
        this.numOwners = numOwners;
        this.timeout = timeout;
        this.totalOrder = totalOrder;
        this.distributed = distributed;
        this.capacityFactor = capacityFactor;
    }

    public ConsistentHashFactory getConsistentHashFactory() {
        return this.consistentHashFactory;
    }

    public Hash getHashFunction() {
        return this.hashFunction;
    }

    public int getNumSegments() {
        return this.numSegments;
    }

    public int getNumOwners() {
        return this.numOwners;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isTotalOrder() {
        return this.totalOrder;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public float getCapacityFactor() {
        return this.capacityFactor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.capacityFactor);
        result = 31 * result + (this.consistentHashFactory == null ? 0 : this.consistentHashFactory.hashCode());
        result = 31 * result + (this.distributed ? 1231 : 1237);
        result = 31 * result + (this.hashFunction == null ? 0 : this.hashFunction.hashCode());
        result = 31 * result + this.numOwners;
        result = 31 * result + this.numSegments;
        result = 31 * result + (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + (this.totalOrder ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheJoinInfo other = (CacheJoinInfo)obj;
        if (Float.floatToIntBits(this.capacityFactor) != Float.floatToIntBits(other.capacityFactor)) {
            return false;
        }
        if (this.consistentHashFactory == null ? other.consistentHashFactory != null : !this.consistentHashFactory.equals(other.consistentHashFactory)) {
            return false;
        }
        if (this.distributed != other.distributed) {
            return false;
        }
        if (this.hashFunction == null ? other.hashFunction != null : !this.hashFunction.equals(other.hashFunction)) {
            return false;
        }
        if (this.numOwners != other.numOwners) {
            return false;
        }
        if (this.numSegments != other.numSegments) {
            return false;
        }
        if (this.timeout != other.timeout) {
            return false;
        }
        return this.totalOrder == other.totalOrder;
    }

    public String toString() {
        return "CacheJoinInfo{consistentHashFactory=" + this.consistentHashFactory + ", hashFunction=" + this.hashFunction + ", numSegments=" + this.numSegments + ", numOwners=" + this.numOwners + ", timeout=" + this.timeout + ", totalOrder=" + this.totalOrder + ", distributed=" + this.distributed + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<CacheJoinInfo> {
        public void writeObject(ObjectOutput output, CacheJoinInfo cacheJoinInfo) throws IOException {
            output.writeObject(cacheJoinInfo.consistentHashFactory);
            output.writeObject(cacheJoinInfo.hashFunction);
            output.writeInt(cacheJoinInfo.numSegments);
            output.writeInt(cacheJoinInfo.numOwners);
            output.writeLong(cacheJoinInfo.timeout);
            output.writeBoolean(cacheJoinInfo.totalOrder);
            output.writeBoolean(cacheJoinInfo.distributed);
            output.writeFloat(cacheJoinInfo.capacityFactor);
        }

        public CacheJoinInfo readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            ConsistentHashFactory consistentHashFactory = (ConsistentHashFactory)unmarshaller.readObject();
            Hash hashFunction = (Hash)unmarshaller.readObject();
            int numSegments = unmarshaller.readInt();
            int numOwners = unmarshaller.readInt();
            long timeout = unmarshaller.readLong();
            boolean totalOrder = unmarshaller.readBoolean();
            boolean distributed = unmarshaller.readBoolean();
            float capacityFactor = unmarshaller.readFloat();
            return new CacheJoinInfo(consistentHashFactory, hashFunction, numSegments, numOwners, timeout, totalOrder, distributed, capacityFactor);
        }

        public Integer getId() {
            return 87;
        }

        public Set<Class<? extends CacheJoinInfo>> getTypeClasses() {
            return Collections.singleton(CacheJoinInfo.class);
        }
    }
}

