/*
 * Decompiled with CFR 0.152.
 */
package org.proton.plug.context;

import org.apache.qpid.proton.engine.Receiver;
import org.proton.plug.AMQPSessionCallback;
import org.proton.plug.context.AbstractConnectionContext;
import org.proton.plug.context.AbstractProtonSessionContext;
import org.proton.plug.context.ProtonDeliveryHandler;
import org.proton.plug.context.ProtonInitializable;
import org.proton.plug.exceptions.ActiveMQAMQPException;

public abstract class AbstractProtonReceiverContext
extends ProtonInitializable
implements ProtonDeliveryHandler {
    protected final AbstractConnectionContext connection;
    protected final AbstractProtonSessionContext protonSession;
    protected final Receiver receiver;
    protected final String address;
    protected final AMQPSessionCallback sessionSPI;

    public AbstractProtonReceiverContext(AMQPSessionCallback sessionSPI, AbstractConnectionContext connection, AbstractProtonSessionContext protonSession, Receiver receiver) {
        this.connection = connection;
        this.protonSession = protonSession;
        this.receiver = receiver;
        this.address = receiver.getRemoteTarget() != null ? receiver.getRemoteTarget().getAddress() : null;
        this.sessionSPI = sessionSPI;
    }

    @Override
    public void close() throws ActiveMQAMQPException {
        this.protonSession.removeReceiver(this.receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flow(int credits) {
        Object object = this.connection.getLock();
        synchronized (object) {
            this.receiver.flow(credits);
        }
        this.connection.flush();
    }
}

