/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.cpu;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;

public class ProcessorInfo {
    private static final String CPUS_ALLOWED = "Cpus_allowed:";
    private static final byte[] BITS = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    private static final Charset ASCII = Charset.forName("US-ASCII");

    public static int availableProcessors() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    return ProcessorInfo.determineProcessors();
                }
            });
        }
        return ProcessorInfo.determineProcessors();
    }

    private static int determineProcessors() {
        int javaProcs = Runtime.getRuntime().availableProcessors();
        if (!ProcessorInfo.isLinux()) {
            return javaProcs;
        }
        int maskProcs = 0;
        try {
            maskProcs = ProcessorInfo.readCPUMask();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maskProcs > 0 ? Math.min(javaProcs, maskProcs) : javaProcs;
    }

    private static int readCPUMask() throws IOException {
        FileInputStream stream = new FileInputStream("/proc/self/status");
        InputStreamReader inputReader = new InputStreamReader((InputStream)stream, ASCII);
        try (BufferedReader reader = new BufferedReader(inputReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                int start;
                if (!line.startsWith(CPUS_ALLOWED)) continue;
                int count = 0;
                for (int i = start = CPUS_ALLOWED.length(); i < line.length(); ++i) {
                    char ch = line.charAt(i);
                    if (ch >= '0' && ch <= '9') {
                        count += BITS[ch - 48];
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'f') {
                        count += BITS[ch - 97 + 10];
                        continue;
                    }
                    if (ch < 'A' || ch > 'F') continue;
                    count += BITS[ch - 65 + 10];
                }
                int n = count;
                return n;
            }
        }
        return -1;
    }

    private static boolean isLinux() {
        String osArch = System.getProperty("os.name", "unknown").toLowerCase(Locale.US);
        return osArch.contains("linux");
    }
}

