/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.databinding.jaxb;

import com.sun.tools.xjc.api.ErrorListener;
import org.apache.cxf.tools.common.ToolErrorListener;
import org.xml.sax.SAXParseException;

public class JAXBBindErrorListener
implements ErrorListener {
    private boolean isVerbose;
    private ToolErrorListener listener;

    public JAXBBindErrorListener(boolean verbose, ToolErrorListener l) {
        this.isVerbose = verbose;
        this.listener = l;
    }

    public boolean hasErrors() {
        return this.listener.getErrorCount() > 0;
    }

    public void error(SAXParseException exception) {
        this.listener.addError(exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), this.mapMessage(exception.getLocalizedMessage()), (Throwable)exception);
    }

    public void fatalError(SAXParseException exception) {
        this.error(exception);
    }

    public void info(SAXParseException exception) {
        if (this.isVerbose) {
            System.out.println("JAXB Info: " + exception.toString() + " in schema " + exception.getSystemId());
        }
    }

    public void warning(SAXParseException exception) {
        for (StackTraceElement el : new Exception().getStackTrace()) {
            if (!el.getClassName().contains("DowngradingErrorHandler")) continue;
            return;
        }
        if (this.isVerbose) {
            System.out.println("JAXB parsing schema warning " + exception.toString() + " in schema " + exception.getSystemId());
        }
        this.listener.addWarning(exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), this.mapMessage(exception.getLocalizedMessage()), (Throwable)exception);
    }

    private String mapMessage(String msg) {
        if (msg.contains("Use a class customization to resolve") && msg.contains("with the same name")) {
            int idx = msg.lastIndexOf("class customization") + 19;
            msg = msg.substring(0, idx) + " or the -autoNameResolution option" + msg.substring(idx);
        }
        return msg;
    }
}

