/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.BooleanType;
import org.apache.qpid.proton.codec.ByteType;
import org.apache.qpid.proton.codec.CharacterType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.DoubleType;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FloatType;
import org.apache.qpid.proton.codec.IntegerType;
import org.apache.qpid.proton.codec.LargeFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.LongType;
import org.apache.qpid.proton.codec.PrimitiveType;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.ShortType;
import org.apache.qpid.proton.codec.SmallFloatingSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeConstructor;
import org.apache.qpid.proton.codec.TypeEncoding;

public class ArrayType
implements PrimitiveType<Object[]> {
    private final EncoderImpl _encoder;
    private final BooleanType _booleanType;
    private final ByteType _byteType;
    private final ShortType _shortType;
    private final IntegerType _integerType;
    private final LongType _longType;
    private final FloatType _floatType;
    private final DoubleType _doubleType;
    private final CharacterType _characterType;
    private final ArrayEncoding _shortArrayEncoding;
    private final ArrayEncoding _arrayEncoding;

    public ArrayType(EncoderImpl encoder, DecoderImpl decoder, BooleanType boolType, ByteType byteType, ShortType shortType, IntegerType intType, LongType longType, FloatType floatType, DoubleType doubleType, CharacterType characterType) {
        this._encoder = encoder;
        this._booleanType = boolType;
        this._byteType = byteType;
        this._shortType = shortType;
        this._integerType = intType;
        this._longType = longType;
        this._floatType = floatType;
        this._doubleType = doubleType;
        this._characterType = characterType;
        this._arrayEncoding = new AllArrayEncoding(encoder, decoder);
        this._shortArrayEncoding = new ShortArrayEncoding(encoder, decoder);
        encoder.register(Object[].class, this);
        decoder.register(this);
    }

    @Override
    public Class<Object[]> getTypeClass() {
        return Object[].class;
    }

    public ArrayEncoding getEncoding(Object[] val) {
        TypeEncoding encoder = ArrayType.calculateEncoder(val, this._encoder);
        int size = ArrayType.calculateSize(val, encoder);
        ArrayEncoding arrayEncoding = val.length > 255 || size > 254 ? this._arrayEncoding : this._shortArrayEncoding;
        arrayEncoding.setValue(val, encoder, size);
        return arrayEncoding;
    }

    private static TypeEncoding calculateEncoder(Object[] val, EncoderImpl encoder) {
        if (val.length == 0) {
            AMQPType underlyingType = encoder.getTypeFromClass(val.getClass().getComponentType());
            return underlyingType.getCanonicalEncoding();
        }
        AMQPType underlyingType = encoder.getTypeFromClass(val.getClass().getComponentType());
        boolean checkTypes = false;
        if (val[0].getClass().isArray() && val[0].getClass().getComponentType().isPrimitive()) {
            Class<?> componentType = val[0].getClass().getComponentType();
            if (componentType == Boolean.TYPE) {
                return ((ArrayType)underlyingType).getEncoding((boolean[])val[0]);
            }
            if (componentType == Byte.TYPE) {
                return ((ArrayType)underlyingType).getEncoding((byte[])val[0]);
            }
            if (componentType == Short.TYPE) {
                return ((ArrayType)underlyingType).getEncoding((short[])val[0]);
            }
            if (componentType == Integer.TYPE) {
                return ((ArrayType)underlyingType).getEncoding((int[])val[0]);
            }
            if (componentType == Long.TYPE) {
                return ((ArrayType)underlyingType).getEncoding((long[])val[0]);
            }
            if (componentType == Float.TYPE) {
                return ((ArrayType)underlyingType).getEncoding((float[])val[0]);
            }
            if (componentType == Double.TYPE) {
                return ((ArrayType)underlyingType).getEncoding((double[])val[0]);
            }
            if (componentType == Character.TYPE) {
                return ((ArrayType)underlyingType).getEncoding((char[])val[0]);
            }
            throw new IllegalArgumentException("Cannot encode arrays of type " + componentType.getName());
        }
        if (underlyingType == null) {
            checkTypes = true;
            underlyingType = encoder.getType(val[0]);
        }
        TypeEncoding<Object> underlyingEncoding = underlyingType.getEncoding(val[0]);
        TypeEncoding canonicalEncoding = underlyingType.getCanonicalEncoding();
        for (int i = 0; i < val.length && (checkTypes || underlyingEncoding != canonicalEncoding); ++i) {
            if (checkTypes && encoder.getType(val[i]) != underlyingType) {
                throw new IllegalArgumentException("Non matching types " + underlyingType + " and " + encoder.getType(val[i]) + " in array");
            }
            TypeEncoding<Object> elementEncoding = underlyingType.getEncoding(val[i]);
            if (elementEncoding == underlyingEncoding || underlyingEncoding.encodesSuperset(elementEncoding)) continue;
            underlyingEncoding = elementEncoding.encodesSuperset(underlyingEncoding) ? elementEncoding : canonicalEncoding;
        }
        return underlyingEncoding;
    }

    private static int calculateSize(Object[] val, TypeEncoding encoder) {
        int size = encoder.getConstructorSize();
        if (encoder.isFixedSizeVal()) {
            size += val.length * encoder.getValueSize(null);
        } else {
            for (Object o : val) {
                if (o.getClass().isArray() && o.getClass().getComponentType().isPrimitive()) {
                    int componentCount;
                    PrimitiveTypeEncoding<Boolean> componentEncoding;
                    Object[] componentArray;
                    ArrayEncoding arrayEncoding = (ArrayEncoding)encoder;
                    ArrayType arrayType = (ArrayType)arrayEncoding.getType();
                    Class<?> componentType = o.getClass().getComponentType();
                    size += 2 * arrayEncoding.getSizeBytes();
                    if (componentType == Boolean.TYPE) {
                        componentArray = (boolean[])o;
                        componentEncoding = arrayType.getUnderlyingEncoding((boolean[])componentArray);
                        componentCount = componentArray.length;
                    } else if (componentType == Byte.TYPE) {
                        componentArray = (byte[])o;
                        componentEncoding = arrayType.getUnderlyingEncoding((byte[])componentArray);
                        componentCount = componentArray.length;
                    } else if (componentType == Short.TYPE) {
                        componentArray = (short[])o;
                        componentEncoding = arrayType.getUnderlyingEncoding((short[])componentArray);
                        componentCount = componentArray.length;
                    } else if (componentType == Integer.TYPE) {
                        componentArray = (int[])o;
                        componentEncoding = arrayType.getUnderlyingEncoding((int[])componentArray);
                        componentCount = componentArray.length;
                    } else if (componentType == Long.TYPE) {
                        componentArray = (long[])o;
                        componentEncoding = arrayType.getUnderlyingEncoding((long[])componentArray);
                        componentCount = componentArray.length;
                    } else if (componentType == Float.TYPE) {
                        componentArray = (float[])o;
                        componentEncoding = arrayType.getUnderlyingEncoding((float[])componentArray);
                        componentCount = componentArray.length;
                    } else if (componentType == Double.TYPE) {
                        componentArray = (double[])o;
                        componentEncoding = arrayType.getUnderlyingEncoding((double[])componentArray);
                        componentCount = componentArray.length;
                    } else if (componentType == Character.TYPE) {
                        componentArray = (char[])o;
                        componentEncoding = arrayType.getUnderlyingEncoding((char[])componentArray);
                        componentCount = componentArray.length;
                    } else {
                        throw new IllegalArgumentException("Cannot encode arrays of type " + componentType.getName());
                    }
                    size += componentEncoding.getConstructorSize() + componentEncoding.getValueSize(null) * componentCount;
                    continue;
                }
                size += encoder.getValueSize(o);
            }
        }
        return size;
    }

    public ArrayEncoding getCanonicalEncoding() {
        return this._arrayEncoding;
    }

    @Override
    public Collection<ArrayEncoding> getAllEncodings() {
        return Arrays.asList(this._shortArrayEncoding, this._arrayEncoding);
    }

    @Override
    public void write(Object[] val) {
        ArrayEncoding encoding = this.getEncoding(val);
        encoding.writeConstructor();
        encoding.writeValue(val);
    }

    @Override
    public void write(boolean[] a) {
        ArrayEncoding encoding = this.getEncoding(a);
        encoding.writeConstructor();
        encoding.writeValue(a);
    }

    private ArrayEncoding getEncoding(boolean[] a) {
        return a.length < 254 || a.length <= 255 && this.allSameValue(a) ? this._shortArrayEncoding : this._arrayEncoding;
    }

    private boolean allSameValue(boolean[] a) {
        boolean val = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (val == a[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void write(byte[] a) {
        ArrayEncoding encoding = this.getEncoding(a);
        encoding.writeConstructor();
        encoding.writeValue(a);
    }

    private ArrayEncoding getEncoding(byte[] a) {
        return a.length < 254 ? this._shortArrayEncoding : this._arrayEncoding;
    }

    @Override
    public void write(short[] a) {
        ArrayEncoding encoding = this.getEncoding(a);
        encoding.writeConstructor();
        encoding.writeValue(a);
    }

    private ArrayEncoding getEncoding(short[] a) {
        return a.length < 127 ? this._shortArrayEncoding : this._arrayEncoding;
    }

    @Override
    public void write(int[] a) {
        ArrayEncoding encoding = this.getEncoding(a);
        encoding.writeConstructor();
        encoding.writeValue(a);
    }

    private ArrayEncoding getEncoding(int[] a) {
        return a.length < 63 || a.length < 254 && this.allSmallInts(a) ? this._shortArrayEncoding : this._arrayEncoding;
    }

    private boolean allSmallInts(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] >= -128 && a[i] <= 127) continue;
            return false;
        }
        return true;
    }

    @Override
    public void write(long[] a) {
        ArrayEncoding encoding = this.getEncoding(a);
        encoding.writeConstructor();
        encoding.writeValue(a);
    }

    private ArrayEncoding getEncoding(long[] a) {
        return a.length < 31 || a.length < 254 && this.allSmallLongs(a) ? this._shortArrayEncoding : this._arrayEncoding;
    }

    private boolean allSmallLongs(long[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] >= -128L && a[i] <= 127L) continue;
            return false;
        }
        return true;
    }

    @Override
    public void write(float[] a) {
        ArrayEncoding encoding = this.getEncoding(a);
        encoding.writeConstructor();
        encoding.writeValue(a);
    }

    private ArrayEncoding getEncoding(float[] a) {
        return a.length < 63 ? this._shortArrayEncoding : this._arrayEncoding;
    }

    @Override
    public void write(double[] a) {
        ArrayEncoding encoding = this.getEncoding(a);
        encoding.writeConstructor();
        encoding.writeValue(a);
    }

    private ArrayEncoding getEncoding(double[] a) {
        return a.length < 31 ? this._shortArrayEncoding : this._arrayEncoding;
    }

    @Override
    public void write(char[] a) {
        ArrayEncoding encoding = this.getEncoding(a);
        encoding.writeConstructor();
        encoding.writeValue(a);
    }

    private ArrayEncoding getEncoding(char[] a) {
        return a.length < 63 ? this._shortArrayEncoding : this._arrayEncoding;
    }

    private BooleanType.BooleanEncoding getUnderlyingEncoding(boolean[] a) {
        if (a.length == 0) {
            return this._booleanType.getCanonicalEncoding();
        }
        boolean val = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (val == a[i]) continue;
            return this._booleanType.getCanonicalEncoding();
        }
        return this._booleanType.getEncoding(val);
    }

    private ByteType.ByteEncoding getUnderlyingEncoding(byte[] a) {
        return this._byteType.getCanonicalEncoding();
    }

    private ShortType.ShortEncoding getUnderlyingEncoding(short[] a) {
        return this._shortType.getCanonicalEncoding();
    }

    private IntegerType.IntegerEncoding getUnderlyingEncoding(int[] a) {
        if (a.length == 0 || !this.allSmallInts(a)) {
            return this._integerType.getCanonicalEncoding();
        }
        return this._integerType.getEncoding(a[0]);
    }

    private LongType.LongEncoding getUnderlyingEncoding(long[] a) {
        if (a.length == 0 || !this.allSmallLongs(a)) {
            return this._longType.getCanonicalEncoding();
        }
        return this._longType.getEncoding(a[0]);
    }

    private FloatType.FloatEncoding getUnderlyingEncoding(float[] a) {
        return this._floatType.getCanonicalEncoding();
    }

    private DoubleType.DoubleEncoding getUnderlyingEncoding(double[] a) {
        return this._doubleType.getCanonicalEncoding();
    }

    private CharacterType.CharacterEncoding getUnderlyingEncoding(char[] a) {
        return this._characterType.getCanonicalEncoding();
    }

    private static Object[] decodeArray(DecoderImpl decoder, int count) {
        TypeConstructor constructor = decoder.readConstructor();
        return ArrayType.decodeNonPrimitive(constructor, count);
    }

    private static Object[] decodeNonPrimitive(TypeConstructor constructor, int count) {
        if (constructor instanceof ArrayEncoding) {
            ArrayEncoding arrayEncoding = (ArrayEncoding)constructor;
            Object[] array = new Object[count];
            for (int i = 0; i < count; ++i) {
                array[i] = arrayEncoding.readValueArray();
            }
            return array;
        }
        Object[] array = (Object[])Array.newInstance(constructor.getTypeClass(), count);
        for (int i = 0; i < count; ++i) {
            array[i] = constructor.readValue();
        }
        return array;
    }

    private static Object decodeArrayAsObject(DecoderImpl decoder, int count) {
        TypeConstructor constructor = decoder.readConstructor();
        if (constructor.encodesJavaPrimitive()) {
            if (constructor instanceof BooleanType.BooleanEncoding) {
                return ArrayType.decodeBooleanArray((BooleanType.BooleanEncoding)constructor, count);
            }
            if (constructor instanceof ByteType.ByteEncoding) {
                return ArrayType.decodeByteArray((ByteType.ByteEncoding)constructor, count);
            }
            if (constructor instanceof ShortType.ShortEncoding) {
                return ArrayType.decodeShortArray((ShortType.ShortEncoding)constructor, count);
            }
            if (constructor instanceof IntegerType.IntegerEncoding) {
                return ArrayType.decodeIntArray((IntegerType.IntegerEncoding)constructor, count);
            }
            if (constructor instanceof LongType.LongEncoding) {
                return ArrayType.decodeLongArray((LongType.LongEncoding)constructor, count);
            }
            if (constructor instanceof FloatType.FloatEncoding) {
                return ArrayType.decodeFloatArray((FloatType.FloatEncoding)constructor, count);
            }
            if (constructor instanceof DoubleType.DoubleEncoding) {
                return ArrayType.decodeDoubleArray((DoubleType.DoubleEncoding)constructor, count);
            }
            throw new ClassCastException("Unexpected class " + constructor.getClass().getName());
        }
        return ArrayType.decodeNonPrimitive(constructor, count);
    }

    private static boolean[] decodeBooleanArray(BooleanType.BooleanEncoding constructor, int count) {
        boolean[] array = new boolean[count];
        for (int i = 0; i < count; ++i) {
            array[i] = constructor.readPrimitiveValue();
        }
        return array;
    }

    private static byte[] decodeByteArray(ByteType.ByteEncoding constructor, int count) {
        byte[] array = new byte[count];
        for (int i = 0; i < count; ++i) {
            array[i] = constructor.readPrimitiveValue();
        }
        return array;
    }

    private static short[] decodeShortArray(ShortType.ShortEncoding constructor, int count) {
        short[] array = new short[count];
        for (int i = 0; i < count; ++i) {
            array[i] = constructor.readPrimitiveValue();
        }
        return array;
    }

    private static int[] decodeIntArray(IntegerType.IntegerEncoding constructor, int count) {
        int[] array = new int[count];
        for (int i = 0; i < count; ++i) {
            array[i] = constructor.readPrimitiveValue();
        }
        return array;
    }

    private static long[] decodeLongArray(LongType.LongEncoding constructor, int count) {
        long[] array = new long[count];
        for (int i = 0; i < count; ++i) {
            array[i] = constructor.readPrimitiveValue();
        }
        return array;
    }

    private static float[] decodeFloatArray(FloatType.FloatEncoding constructor, int count) {
        float[] array = new float[count];
        for (int i = 0; i < count; ++i) {
            array[i] = constructor.readPrimitiveValue();
        }
        return array;
    }

    private static double[] decodeDoubleArray(DoubleType.DoubleEncoding constructor, int count) {
        double[] array = new double[count];
        for (int i = 0; i < count; ++i) {
            array[i] = constructor.readPrimitiveValue();
        }
        return array;
    }

    private class ShortArrayEncoding
    extends SmallFloatingSizePrimitiveTypeEncoding<Object[]>
    implements ArrayEncoding {
        private Object[] _val;
        private TypeEncoding _underlyingEncoder;
        private int _size;

        ShortArrayEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        public void writeValue(boolean[] a) {
            BooleanType.BooleanEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw((byte)(1 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null)));
            this.getEncoder().writeRaw((byte)a.length);
            underlyingEncoder.writeConstructor();
            for (boolean b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void writeValue(byte[] a) {
            ByteType.ByteEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw((byte)(1 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null)));
            this.getEncoder().writeRaw((byte)a.length);
            underlyingEncoder.writeConstructor();
            for (byte b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void writeValue(short[] a) {
            ShortType.ShortEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw((byte)(1 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null)));
            this.getEncoder().writeRaw((byte)a.length);
            underlyingEncoder.writeConstructor();
            for (short b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void writeValue(int[] a) {
            IntegerType.IntegerEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw((byte)(1 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null)));
            this.getEncoder().writeRaw((byte)a.length);
            underlyingEncoder.writeConstructor();
            for (int b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void writeValue(long[] a) {
            LongType.LongEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw((byte)(1 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null)));
            this.getEncoder().writeRaw((byte)a.length);
            underlyingEncoder.writeConstructor();
            for (long b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void writeValue(float[] a) {
            FloatType.FloatEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw((byte)(1 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null)));
            this.getEncoder().writeRaw((byte)a.length);
            underlyingEncoder.writeConstructor();
            for (float b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void writeValue(double[] a) {
            DoubleType.DoubleEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw((byte)(1 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null)));
            this.getEncoder().writeRaw((byte)a.length);
            underlyingEncoder.writeConstructor();
            for (double b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void writeValue(char[] a) {
            CharacterType.CharacterEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw((byte)(1 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null)));
            this.getEncoder().writeRaw((byte)a.length);
            underlyingEncoder.writeConstructor();
            for (char b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void setValue(Object[] val, TypeEncoding encoder, int size) {
            this._val = val;
            this._underlyingEncoder = encoder;
            this._size = size;
        }

        @Override
        protected void writeEncodedValue(Object[] val) {
            TypeEncoding underlyingEncoder;
            if (this._val != val) {
                this._val = val;
                this._underlyingEncoder = underlyingEncoder = ArrayType.calculateEncoder(val, this.getEncoder());
                this._size = ArrayType.calculateSize(val, underlyingEncoder);
            } else {
                underlyingEncoder = this._underlyingEncoder;
            }
            this.getEncoder().writeRaw((byte)val.length);
            underlyingEncoder.writeConstructor();
            for (Object o : val) {
                if (o.getClass().isArray() && o.getClass().getComponentType().isPrimitive()) {
                    Object[] componentArray;
                    ArrayEncoding arrayEncoding = (ArrayEncoding)underlyingEncoder;
                    ArrayType arrayType = (ArrayType)arrayEncoding.getType();
                    Class<?> componentType = o.getClass().getComponentType();
                    if (componentType == Boolean.TYPE) {
                        componentArray = (boolean[])o;
                        arrayEncoding.writeValue((boolean[])componentArray);
                        continue;
                    }
                    if (componentType == Byte.TYPE) {
                        componentArray = (byte[])o;
                        arrayEncoding.writeValue((byte[])componentArray);
                        continue;
                    }
                    if (componentType == Short.TYPE) {
                        componentArray = (short[])o;
                        arrayEncoding.writeValue((short[])componentArray);
                        continue;
                    }
                    if (componentType == Integer.TYPE) {
                        componentArray = (int[])o;
                        arrayEncoding.writeValue((int[])componentArray);
                        continue;
                    }
                    if (componentType == Long.TYPE) {
                        componentArray = (long[])o;
                        arrayEncoding.writeValue((long[])componentArray);
                        continue;
                    }
                    if (componentType == Float.TYPE) {
                        componentArray = (float[])o;
                        arrayEncoding.writeValue((float[])componentArray);
                        continue;
                    }
                    if (componentType == Double.TYPE) {
                        componentArray = (double[])o;
                        arrayEncoding.writeValue((double[])componentArray);
                        continue;
                    }
                    if (componentType == Character.TYPE) {
                        componentArray = (char[])o;
                        arrayEncoding.writeValue((char[])componentArray);
                        continue;
                    }
                    throw new IllegalArgumentException("Cannot encode arrays of type " + componentType.getName());
                }
                underlyingEncoder.writeValue(o);
            }
        }

        @Override
        protected int getEncodedValueSize(Object[] val) {
            if (this._val != val) {
                this._val = val;
                this._underlyingEncoder = ArrayType.calculateEncoder(val, this.getEncoder());
                this._size = ArrayType.calculateSize(val, this._underlyingEncoder);
            }
            return 1 + this._size;
        }

        @Override
        public byte getEncodingCode() {
            return -32;
        }

        public ArrayType getType() {
            return ArrayType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Object[]> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Object[] readValue() {
            DecoderImpl decoder = this.getDecoder();
            int size = decoder.readRawByte() & 0xFF;
            int count = decoder.readRawByte() & 0xFF;
            return ArrayType.decodeArray(decoder, count);
        }

        @Override
        public Object readValueArray() {
            DecoderImpl decoder = this.getDecoder();
            int size = decoder.readRawByte() & 0xFF;
            int count = decoder.readRawByte() & 0xFF;
            return ArrayType.decodeArrayAsObject(decoder, count);
        }
    }

    private class AllArrayEncoding
    extends LargeFloatingSizePrimitiveTypeEncoding<Object[]>
    implements ArrayEncoding {
        private Object[] _val;
        private TypeEncoding _underlyingEncoder;
        private int _size;

        AllArrayEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        public void writeValue(boolean[] a) {
            BooleanType.BooleanEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw(4 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null));
            this.getEncoder().writeRaw(a.length);
            underlyingEncoder.writeConstructor();
            for (boolean b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void writeValue(byte[] a) {
            ByteType.ByteEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw(4 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null));
            this.getEncoder().writeRaw(a.length);
            underlyingEncoder.writeConstructor();
            for (byte b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void writeValue(short[] a) {
            ShortType.ShortEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw(4 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null));
            this.getEncoder().writeRaw(a.length);
            underlyingEncoder.writeConstructor();
            for (short b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void writeValue(int[] a) {
            IntegerType.IntegerEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw(4 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null));
            this.getEncoder().writeRaw(a.length);
            underlyingEncoder.writeConstructor();
            for (int b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void writeValue(long[] a) {
            LongType.LongEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw(4 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null));
            this.getEncoder().writeRaw(a.length);
            underlyingEncoder.writeConstructor();
            for (long b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void writeValue(float[] a) {
            FloatType.FloatEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw(4 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null));
            this.getEncoder().writeRaw(a.length);
            underlyingEncoder.writeConstructor();
            for (float b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void writeValue(double[] a) {
            DoubleType.DoubleEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw(4 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null));
            this.getEncoder().writeRaw(a.length);
            underlyingEncoder.writeConstructor();
            for (double b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void writeValue(char[] a) {
            CharacterType.CharacterEncoding underlyingEncoder = ArrayType.this.getUnderlyingEncoding(a);
            this.getEncoder().writeRaw(4 + underlyingEncoder.getConstructorSize() + a.length * underlyingEncoder.getValueSize(null));
            this.getEncoder().writeRaw(a.length);
            underlyingEncoder.writeConstructor();
            for (char b : a) {
                underlyingEncoder.writeValue(b);
            }
        }

        @Override
        public void setValue(Object[] val, TypeEncoding encoder, int size) {
            this._val = val;
            this._underlyingEncoder = encoder;
            this._size = size;
        }

        @Override
        protected void writeEncodedValue(Object[] val) {
            TypeEncoding underlyingEncoder;
            if (this._val != val) {
                this._val = val;
                this._underlyingEncoder = underlyingEncoder = ArrayType.calculateEncoder(val, this.getEncoder());
                this._size = ArrayType.calculateSize(val, underlyingEncoder);
            } else {
                underlyingEncoder = this._underlyingEncoder;
            }
            this.getEncoder().writeRaw(val.length);
            underlyingEncoder.writeConstructor();
            for (Object o : val) {
                underlyingEncoder.writeValue(o);
            }
        }

        @Override
        protected int getEncodedValueSize(Object[] val) {
            if (this._val != val) {
                this._val = val;
                this._underlyingEncoder = ArrayType.calculateEncoder(val, this.getEncoder());
                this._size = ArrayType.calculateSize(val, this._underlyingEncoder);
            }
            return 4 + this._size;
        }

        @Override
        public byte getEncodingCode() {
            return -16;
        }

        public ArrayType getType() {
            return ArrayType.this;
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Object[]> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Object[] readValue() {
            DecoderImpl decoder = this.getDecoder();
            int size = decoder.readRawInt();
            int count = decoder.readRawInt();
            return ArrayType.decodeArray(decoder, count);
        }

        @Override
        public Object readValueArray() {
            DecoderImpl decoder = this.getDecoder();
            int size = decoder.readRawInt();
            int count = decoder.readRawInt();
            return ArrayType.decodeArrayAsObject(decoder, count);
        }
    }

    public static interface ArrayEncoding
    extends PrimitiveTypeEncoding<Object[]> {
        @Override
        public void writeValue(boolean[] var1);

        @Override
        public void writeValue(byte[] var1);

        @Override
        public void writeValue(short[] var1);

        @Override
        public void writeValue(int[] var1);

        @Override
        public void writeValue(long[] var1);

        @Override
        public void writeValue(float[] var1);

        @Override
        public void writeValue(double[] var1);

        @Override
        public void writeValue(char[] var1);

        public void setValue(Object[] var1, TypeEncoding var2, int var3);

        public int getSizeBytes();

        public Object readValueArray();
    }
}

