/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class UrlScanner {
    public boolean handleBeansXml(URL url, List<String> discoveredClasses) {
        String urlPath = url.toExternalForm();
        String urlType = "file";
        int colonIndex = urlPath.indexOf(":");
        if (colonIndex != -1) {
            urlType = urlPath.substring(0, colonIndex);
        }
        if ("file".equals(urlType) || "jar".equals(urlType)) {
            urlPath = url.getPath();
            if (urlPath.indexOf(33) > 0) {
                urlPath = urlPath.substring(0, urlPath.indexOf(33));
            } else {
                File dirOrArchive = new File(urlPath);
                dirOrArchive = dirOrArchive.getParentFile();
                urlPath = dirOrArchive.getParent();
            }
            try {
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            this.handle(urlPath, discoveredClasses);
            return true;
        }
        if ("vfs".equals(urlType)) {
            try {
                VirtualFile vfsRoot = VFS.getChild((URL)url).getParent().getParent();
                this.handle(vfsRoot, discoveredClasses);
                return true;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        WeldLogger.DEPLOYMENT_LOGGER.doNotUnderstandProtocol(url);
        return false;
    }

    private void handle(VirtualFile urlPath, List<String> discoveredClasses) {
        WeldLogger.DEPLOYMENT_LOGGER.tracef("scanning: %s", urlPath);
        this.handleDirectory(urlPath, null, discoveredClasses);
    }

    private void handle(String urlPath, List<String> discoveredClasses) {
        try {
            File file;
            WeldLogger.DEPLOYMENT_LOGGER.tracef("scanning: %s", urlPath);
            if (urlPath.startsWith("file:")) {
                urlPath = urlPath.substring(5);
            }
            if (urlPath.indexOf(33) > 0) {
                urlPath = urlPath.substring(0, urlPath.indexOf(33));
            }
            if ((file = new File(urlPath)).isDirectory()) {
                this.handleDirectory(file, null, discoveredClasses);
            } else {
                this.handleArchiveByFile(file, discoveredClasses);
            }
        }
        catch (IOException ioe) {
            WeldLogger.DEPLOYMENT_LOGGER.couldNotReadEntries(ioe);
        }
    }

    private void handleArchiveByFile(File file, List<String> discoveredClasses) throws IOException {
        try {
            WeldLogger.DEPLOYMENT_LOGGER.trace("archive: " + file);
            try (ZipFile zip = new ZipFile(file);){
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    this.handleFile(name, discoveredClasses);
                }
            }
        }
        catch (ZipException e) {
            throw new RuntimeException("Error handling file " + file, e);
        }
    }

    private void handleDirectory(File file, String path, List<String> discoveredClasses) {
        WeldLogger.DEPLOYMENT_LOGGER.tracef("handling directory: %s", file);
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath, discoveredClasses);
                continue;
            }
            this.handleFile(newPath, discoveredClasses);
        }
    }

    private void handleDirectory(VirtualFile file, String path, List<String> discoveredClasses) {
        WeldLogger.DEPLOYMENT_LOGGER.tracef("handling directory: %s", file);
        for (VirtualFile child : file.getChildren()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath, discoveredClasses);
                continue;
            }
            this.handleFile(newPath, discoveredClasses);
        }
    }

    protected void handleFile(String name, List<String> discoveredClasses) {
        if (name.endsWith(".class")) {
            discoveredClasses.add(UrlScanner.filenameToClassname(name));
        }
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }
}

