/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.handlers;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.picketlink.config.federation.KeyValueType;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerParameterRemoveHandler;
import org.wildfly.extension.picketlink.federation.model.handlers.HandlerParameterResourceDefinition;
import org.wildfly.extension.picketlink.federation.service.EntityProviderService;

public class HandlerParameterAddHandler
extends AbstractAddStepHandler {
    static final HandlerParameterAddHandler INSTANCE = new HandlerParameterAddHandler();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attribute : HandlerParameterResourceDefinition.INSTANCE.getAttributes()) {
            attribute.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String providerAlias = pathAddress.subAddress(0, pathAddress.size() - 2).getLastElement().getValue();
        String handlerType = pathAddress.subAddress(0, pathAddress.size() - 1).getLastElement().getValue();
        EntityProviderService providerService = EntityProviderService.getService(context, providerAlias);
        String handlerParameterName = pathAddress.getLastElement().getValue();
        KeyValueType keyValueType = HandlerParameterAddHandler.toHandlerParameterConfig(context, handlerParameterName, model);
        providerService.addHandlerParameter(handlerType, keyValueType);
    }

    public static KeyValueType toHandlerParameterConfig(OperationContext context, String paramName, ModelNode parameterNode) throws OperationFailedException {
        String paramValue = HandlerParameterResourceDefinition.VALUE.resolveModelAttribute(context, parameterNode).asString();
        KeyValueType kv = new KeyValueType();
        kv.setKey(paramName);
        kv.setValue(paramValue);
        return kv;
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        try {
            HandlerParameterRemoveHandler.INSTANCE.performRuntime(context, operation, resource.getModel());
        }
        catch (OperationFailedException operationFailedException) {
            // empty catch block
        }
    }
}

