/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.spec.WebConnectionImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;
import org.xnio.ChannelListener;
import org.xnio.StreamConnection;

public class ServletUpgradeListener<T extends HttpUpgradeHandler>
implements HttpUpgradeListener {
    private final InstanceHandle<T> instance;
    private final ThreadSetupAction threadSetupAction;
    private final HttpServerExchange exchange;

    public ServletUpgradeListener(InstanceHandle<T> instance, ThreadSetupAction threadSetupAction, HttpServerExchange exchange) {
        this.instance = instance;
        this.threadSetupAction = threadSetupAction;
        this.exchange = exchange;
    }

    public void handleUpgrade(final StreamConnection channel, final HttpServerExchange exchange) {
        channel.getCloseSetter().set((ChannelListener)new ChannelListener<StreamConnection>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(StreamConnection channel) {
                ThreadSetupAction.Handle handle = ServletUpgradeListener.this.threadSetupAction.setup(ServletUpgradeListener.this.exchange);
                try {
                    ((HttpUpgradeHandler)ServletUpgradeListener.this.instance.getInstance()).destroy();
                }
                finally {
                    try {
                        handle.tearDown();
                    }
                    finally {
                        ServletUpgradeListener.this.instance.release();
                    }
                }
            }
        });
        this.exchange.getConnection().getWorker().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DelayedExecutor executor = new DelayedExecutor((Executor)exchange.getIoThread());
                ThreadSetupAction.Handle handle = ServletUpgradeListener.this.threadSetupAction.setup(ServletUpgradeListener.this.exchange);
                try {
                    ((HttpUpgradeHandler)ServletUpgradeListener.this.instance.getInstance()).init((WebConnection)new WebConnectionImpl(channel, ServletUpgradeListener.this.exchange.getConnection().getByteBufferPool(), executor));
                }
                finally {
                    try {
                        handle.tearDown();
                    }
                    finally {
                        executor.openGate();
                    }
                }
            }
        });
    }

    private static final class DelayedExecutor
    implements Executor {
        private final Executor delegate;
        private volatile boolean queue = true;
        private final List<Runnable> tasks = new ArrayList<Runnable>();

        private DelayedExecutor(Executor delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            if (!this.queue) {
                this.delegate.execute(command);
            } else {
                DelayedExecutor delayedExecutor = this;
                synchronized (delayedExecutor) {
                    if (!this.queue) {
                        this.delegate.execute(command);
                    } else {
                        this.tasks.add(command);
                    }
                }
            }
        }

        synchronized void openGate() {
            this.queue = false;
            for (Runnable task : this.tasks) {
                this.delegate.execute(task);
            }
        }
    }
}

