/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.ejb.client.SessionID;
import org.wildfly.clustering.marshalling.Externalizer;

public class SessionIDExternalizer
implements Externalizer<SessionID> {
    private final Class<? extends SessionID> targetClass;
    private final Externalizer<Integer> externalizer;

    SessionIDExternalizer(Class<? extends SessionID> targetClass, Externalizer<Integer> externalizer) {
        this.targetClass = targetClass;
        this.externalizer = externalizer;
    }

    public void writeObject(ObjectOutput output, SessionID id) throws IOException {
        byte[] encoded = id.getEncodedForm();
        this.externalizer.writeObject(output, (Object)encoded.length);
        output.write(encoded);
    }

    public SessionID readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        byte[] encoded = new byte[((Integer)this.externalizer.readObject(input)).intValue()];
        input.readFully(encoded);
        return SessionID.createSessionID((byte[])encoded);
    }

    public Class<? extends SessionID> getTargetClass() {
        return this.targetClass;
    }
}

