/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.util.impl;

import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.BridgeException;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.spi.ConversionContext;

public final class ContextualExceptionBridgeHelper
implements ConversionContext {
    private static final String IDENTIFIER = "identifier";
    private Class<?> clazz;
    private StringBridge stringBridge;
    private FieldBridge oneWayBridge;
    private TwoWayFieldBridge twoWayBridge;
    private final ArrayList<String> path = new ArrayList(5);
    private final OneWayConversionContextImpl oneWayAdapter = new OneWayConversionContextImpl();
    private final TwoWayConversionContextImpl twoWayAdapter = new TwoWayConversionContextImpl();
    private final StringConversionContextImpl stringAdapter = new StringConversionContextImpl();

    @Override
    public ConversionContext setClass(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    @Override
    public ConversionContext pushProperty(String property) {
        this.path.add(property);
        return this;
    }

    @Override
    public ConversionContext popProperty() {
        if (this.path.size() == 0) {
            throw new IllegalStateException("Trying to pop a property from an empty conversion context");
        }
        this.path.remove(this.path.size() - 1);
        return this;
    }

    @Override
    public ConversionContext pushIdentifierProperty() {
        this.pushProperty(IDENTIFIER);
        return this;
    }

    protected BridgeException buildBridgeException(Exception e, String method) {
        StringBuilder error = new StringBuilder("Exception while calling bridge#").append(method);
        if (this.clazz != null) {
            error.append("\n\tclass: ").append(this.clazz.getName());
        }
        if (this.path.size() > 0) {
            error.append("\n\tpath: ");
            for (String pathNode : this.path) {
                error.append(pathNode).append(".");
            }
            error.deleteCharAt(error.length() - 1);
        }
        throw new BridgeException(error.toString(), e);
    }

    @Override
    public FieldBridge oneWayConversionContext(FieldBridge delegate) {
        this.oneWayBridge = delegate;
        return this.oneWayAdapter;
    }

    @Override
    public TwoWayFieldBridge twoWayConversionContext(TwoWayFieldBridge delegate) {
        this.twoWayBridge = delegate;
        return this.twoWayAdapter;
    }

    @Override
    public StringBridge stringConversionContext(StringBridge delegate) {
        this.stringBridge = delegate;
        return this.stringAdapter;
    }

    private final class StringConversionContextImpl
    implements StringBridge {
        private StringConversionContextImpl() {
        }

        @Override
        public String objectToString(Object object) {
            try {
                return ContextualExceptionBridgeHelper.this.stringBridge.objectToString(object);
            }
            catch (RuntimeException e) {
                throw ContextualExceptionBridgeHelper.this.buildBridgeException(e, "objectToString");
            }
        }
    }

    private final class TwoWayConversionContextImpl
    implements TwoWayFieldBridge {
        private TwoWayConversionContextImpl() {
        }

        @Override
        public Object get(String name, Document document) {
            try {
                return ContextualExceptionBridgeHelper.this.twoWayBridge.get(name, document);
            }
            catch (RuntimeException e) {
                throw ContextualExceptionBridgeHelper.this.buildBridgeException(e, "get");
            }
        }

        @Override
        public String objectToString(Object object) {
            try {
                return ContextualExceptionBridgeHelper.this.twoWayBridge.objectToString(object);
            }
            catch (RuntimeException e) {
                throw ContextualExceptionBridgeHelper.this.buildBridgeException(e, "objectToString");
            }
        }

        @Override
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            try {
                ContextualExceptionBridgeHelper.this.twoWayBridge.set(name, value, document, luceneOptions);
            }
            catch (RuntimeException e) {
                throw ContextualExceptionBridgeHelper.this.buildBridgeException(e, "set");
            }
        }
    }

    private final class OneWayConversionContextImpl
    implements FieldBridge {
        private OneWayConversionContextImpl() {
        }

        @Override
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            try {
                ContextualExceptionBridgeHelper.this.oneWayBridge.set(name, value, document, luceneOptions);
            }
            catch (RuntimeException e) {
                throw ContextualExceptionBridgeHelper.this.buildBridgeException(e, "set");
            }
        }
    }
}

