/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.basic.Agent;
import org.picketlink.idm.model.basic.Grant;
import org.picketlink.idm.model.basic.Group;
import org.picketlink.idm.model.basic.GroupMembership;
import org.picketlink.idm.model.basic.GroupRole;
import org.picketlink.idm.model.basic.Realm;
import org.picketlink.idm.model.basic.Role;
import org.picketlink.idm.model.basic.Tier;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.permission.Permission;

public enum AttributedTypeEnum {
    PARTITION("Partition", Partition.class.getName()),
    IDENTITY_TYPE("IdentityType", IdentityType.class.getName()),
    ACCOUNT("Account", Account.class.getName()),
    RELATIONSHIP("Relationship", Relationship.class.getName()),
    PERMISSION("Permission", Permission.class.getName()),
    REALM("Realm", Realm.class.getName()),
    TIER("Tier", Tier.class.getName()),
    AGENT("Agent", Agent.class.getName()),
    USER("User", User.class.getName()),
    ROLE("Role", Role.class.getName()),
    GROUP("Group", Group.class.getName()),
    GRANT("Grant", Grant.class.getName()),
    GROUP_ROLE("GroupRole", GroupRole.class.getName()),
    GROUP_MEMBERSHIP("GroupMembership", GroupMembership.class.getName());

    private static final Map<String, AttributedTypeEnum> types;
    private final String alias;
    private final String type;

    private AttributedTypeEnum(String alias, String type) {
        this.alias = alias;
        this.type = type;
    }

    public static String forType(String alias) {
        AttributedTypeEnum resolvedType = types.get(alias);
        if (resolvedType != null) {
            return resolvedType.getType();
        }
        return null;
    }

    public String toString() {
        return this.alias;
    }

    public String getAlias() {
        return this.alias;
    }

    String getType() {
        return this.type;
    }

    static {
        types = new HashMap<String, AttributedTypeEnum>();
        for (AttributedTypeEnum element : AttributedTypeEnum.values()) {
            types.put(element.getAlias(), element);
        }
    }
}

