/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal.authentication.schemes;

import java.io.IOException;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.Identity;
import org.picketlink.config.http.FormAuthenticationConfiguration;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.http.authentication.HttpAuthenticationScheme;
import org.picketlink.http.internal.authentication.schemes.support.RequestCache;
import org.picketlink.http.internal.authentication.schemes.support.SavedRequest;

public class FormAuthenticationScheme
implements HttpAuthenticationScheme<FormAuthenticationConfiguration> {
    public static final String J_SECURITY_CHECK = "j_security_check";
    public static final String J_USERNAME = "j_username";
    public static final String J_PASSWORD = "j_password";
    private final RequestCache requestCache = new RequestCache();
    private FormAuthenticationConfiguration configuration;
    @Inject
    private Instance<Identity> identity;

    public void initialize(FormAuthenticationConfiguration config) {
        this.configuration = config;
    }

    public void extractCredential(HttpServletRequest request, DefaultLoginCredentials creds) {
        if (this.isFormSubmitted(request)) {
            creds.setUserId(request.getParameter(J_USERNAME));
            creds.setPassword(request.getParameter(J_PASSWORD));
        }
    }

    public void challengeClient(HttpServletRequest request, HttpServletResponse response) {
        String requestedUri;
        if (!this.isFormSubmitted(request) && this.configuration.isRestoreOriginalRequest()) {
            this.requestCache.saveRequest(request);
        }
        if (!(requestedUri = request.getRequestURI()).contains(this.configuration.getLoginPageUrl()) && !requestedUri.contains(this.configuration.getErrorPageUrl())) {
            this.forwardToLoginPage(request, response);
        }
    }

    public void onPostAuthentication(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (((Identity)this.identity.get()).isLoggedIn()) {
                SavedRequest savedRequest = this.requestCache.removeAndStoreSavedRequestInSession(request);
                if (savedRequest != null) {
                    response.sendRedirect(savedRequest.getRequestURI());
                }
                if (!this.configuration.isRestoreOriginalRequest() || savedRequest == null) {
                    response.sendRedirect(request.getContextPath());
                }
            } else if (this.isFormSubmitted(request)) {
                this.forwardToErrorPage(request, response);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not perform post authentication tasks after a form-based authentication.", e);
        }
    }

    private void forwardToLoginPage(HttpServletRequest request, HttpServletResponse response) {
        this.forwardToPage(this.configuration.getLoginPageUrl(), request, response);
    }

    private void forwardToErrorPage(HttpServletRequest request, HttpServletResponse response) {
        this.forwardToPage(this.configuration.getErrorPageUrl(), request, response);
    }

    private void forwardToPage(String page, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.sendRedirect(request.getContextPath() + page);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isFormSubmitted(HttpServletRequest request) {
        return request.getRequestURI().contains(J_SECURITY_CHECK);
    }
}

