/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.ctx;

import java.io.ByteArrayInputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.SunxacmlUtil;
import org.jboss.security.xacml.sunxacml.ctx.Attribute;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StatusDetail {
    private Node detailRoot;
    private String detailText = null;

    public StatusDetail(List attributes) throws IllegalArgumentException {
        this.detailText = "<StatusDetail>\n";
        for (Attribute attr : attributes) {
            this.detailText = this.detailText + attr.encode() + "\n";
        }
        this.detailText = this.detailText + "</StatusDetail>";
        try {
            this.detailRoot = this.textToNode(this.detailText);
        }
        catch (ParsingException pe) {
            throw new IllegalArgumentException("invalid Attribute data");
        }
    }

    public StatusDetail(String encoded) throws ParsingException {
        this.detailText = "<StatusDetail>\n" + encoded + "\n</StatusDetail>";
        this.detailRoot = this.textToNode(this.detailText);
    }

    private StatusDetail(Node root) {
        this.detailRoot = root;
    }

    private Node textToNode(String encoded) throws ParsingException {
        try {
            String text = "<?xml version=\"1.0\"?>\n";
            byte[] bytes = (text + encoded).getBytes();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(bytes));
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new ParsingException("invalid XML for status detail");
        }
    }

    public static StatusDetail getInstance(Node root) throws ParsingException {
        if (!SunxacmlUtil.getNodeName(root).equals("StatusDetail")) {
            throw new ParsingException("not a StatusDetail node");
        }
        return new StatusDetail(root);
    }

    public Node getDetail() {
        return this.detailRoot;
    }

    public String getEncoded() throws IllegalStateException {
        if (this.detailText == null) {
            throw new IllegalStateException("no encoded form available");
        }
        return this.detailText;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.detailText == null ? 0 : this.detailText.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatusDetail other = (StatusDetail)obj;
        return !(this.detailText == null ? other.detailText != null : !this.detailText.equals(other.detailText));
    }
}

