/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.util.concurrent.TimeUnit;
import org.jboss.as.process.ManagedProcess;
import org.jboss.as.process.logging.ProcessLogger;

interface RespawnPolicy {
    public static final RespawnPolicy NONE = new RespawnPolicy(){

        @Override
        public void respawn(int count, ManagedProcess process, boolean slowRespawn, boolean unlimited) {
            ProcessLogger.SERVER_LOGGER.tracef("not trying to respawn process %s.", process.getProcessName());
        }
    };
    public static final RespawnPolicy RESPAWN = new RespawnPolicy(){
        private static final int MAX_NORMAL_WAIT = 30;
        private static final int MAX_SLOW_WAIT = 300;
        private static final int MAX_RESTARTS = 10;
        private final int[] NORMAL_WAITS = new int[]{1, 5, 10, 15, 30};
        private final int[] SLOW_WAITS = new int[]{15, 15, 30, 60, 300};

        @Override
        public void respawn(int count, ManagedProcess process, boolean slowRespawn, boolean unlimited) {
            if (unlimited || count <= 10) {
                try {
                    int[] waits;
                    int[] nArray = waits = slowRespawn ? this.SLOW_WAITS : this.NORMAL_WAITS;
                    int waitPeriod = count <= waits.length ? waits[count - 1] : (slowRespawn ? 300 : 30);
                    ProcessLogger.SERVER_LOGGER.waitingToRestart(waitPeriod, process.getProcessName());
                    TimeUnit.SECONDS.sleep(waitPeriod);
                }
                catch (InterruptedException e) {
                    return;
                }
                process.respawn();
            }
        }
    };

    public void respawn(int var1, ManagedProcess var2, boolean var3, boolean var4);
}

