/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.xpath.XPath;
import org.apache.xerces.util.IntStack;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.XSTypeDefinition;

public class XPathMatcher {
    protected static final boolean DEBUG_ALL = false;
    protected static final boolean DEBUG_METHODS = false;
    protected static final boolean DEBUG_METHODS2 = false;
    protected static final boolean DEBUG_METHODS3 = false;
    protected static final boolean DEBUG_MATCH = false;
    protected static final boolean DEBUG_STACK = false;
    protected static final boolean DEBUG_ANY = false;
    protected static final int MATCHED = 1;
    protected static final int MATCHED_ATTRIBUTE = 3;
    protected static final int MATCHED_DESCENDANT = 5;
    protected static final int MATCHED_DESCENDANT_PREVIOUS = 13;
    private final XPath.LocationPath[] fLocationPaths;
    private final int[] fMatched;
    protected Object fMatchedString;
    private final IntStack[] fStepIndexes;
    private final int[] fCurrentStep;
    private final int[] fNoMatchDepth;
    final QName fQName = new QName();

    public XPathMatcher(XPath xpath) {
        this.fLocationPaths = xpath.getLocationPaths();
        this.fStepIndexes = new IntStack[this.fLocationPaths.length];
        for (int i = 0; i < this.fStepIndexes.length; ++i) {
            this.fStepIndexes[i] = new IntStack();
        }
        this.fCurrentStep = new int[this.fLocationPaths.length];
        this.fNoMatchDepth = new int[this.fLocationPaths.length];
        this.fMatched = new int[this.fLocationPaths.length];
    }

    public boolean isMatched() {
        for (int i = 0; i < this.fLocationPaths.length; ++i) {
            if ((this.fMatched[i] & 1) != 1 || (this.fMatched[i] & 0xD) == 13 || this.fNoMatchDepth[i] != 0 && (this.fMatched[i] & 5) != 5) continue;
            return true;
        }
        return false;
    }

    protected void handleContent(XSTypeDefinition type, boolean nillable, Object value, short valueType, ShortList itemValueType) {
    }

    protected void matched(Object actualValue, short valueType, ShortList itemValueType, boolean isNil) {
    }

    public void startDocumentFragment() {
        this.fMatchedString = null;
        for (int i = 0; i < this.fLocationPaths.length; ++i) {
            this.fStepIndexes[i].clear();
            this.fCurrentStep[i] = 0;
            this.fNoMatchDepth[i] = 0;
            this.fMatched[i] = 0;
        }
    }

    public void startElement(QName element, XMLAttributes attributes) {
        for (int i = 0; i < this.fLocationPaths.length; ++i) {
            XPath.NodeTest nodeTest;
            boolean sawDescendant;
            int startStep = this.fCurrentStep[i];
            this.fStepIndexes[i].push(startStep);
            if ((this.fMatched[i] & 5) == 1 || this.fNoMatchDepth[i] > 0) {
                int n = i;
                this.fNoMatchDepth[n] = this.fNoMatchDepth[n] + 1;
                continue;
            }
            if ((this.fMatched[i] & 5) == 5) {
                this.fMatched[i] = 13;
            }
            XPath.Step[] steps = this.fLocationPaths[i].steps;
            while (this.fCurrentStep[i] < steps.length && steps[this.fCurrentStep[i]].axis.type == 3) {
                int n = i;
                this.fCurrentStep[n] = this.fCurrentStep[n] + 1;
            }
            if (this.fCurrentStep[i] == steps.length) {
                this.fMatched[i] = 1;
                continue;
            }
            int descendantStep = this.fCurrentStep[i];
            while (this.fCurrentStep[i] < steps.length && steps[this.fCurrentStep[i]].axis.type == 4) {
                int n = i;
                this.fCurrentStep[n] = this.fCurrentStep[n] + 1;
            }
            boolean bl = sawDescendant = this.fCurrentStep[i] > descendantStep;
            if (this.fCurrentStep[i] == steps.length) {
                int n = i;
                this.fNoMatchDepth[n] = this.fNoMatchDepth[n] + 1;
                continue;
            }
            if ((this.fCurrentStep[i] == startStep || this.fCurrentStep[i] > descendantStep) && steps[this.fCurrentStep[i]].axis.type == 1) {
                XPath.Step step = steps[this.fCurrentStep[i]];
                nodeTest = step.nodeTest;
                if (!XPathMatcher.matches(nodeTest, element)) {
                    if (this.fCurrentStep[i] > descendantStep) {
                        this.fCurrentStep[i] = descendantStep;
                        continue;
                    }
                    int n = i;
                    this.fNoMatchDepth[n] = this.fNoMatchDepth[n] + 1;
                    continue;
                }
                int n = i;
                this.fCurrentStep[n] = this.fCurrentStep[n] + 1;
            }
            if (this.fCurrentStep[i] == steps.length) {
                if (sawDescendant) {
                    this.fCurrentStep[i] = descendantStep;
                    this.fMatched[i] = 5;
                    continue;
                }
                this.fMatched[i] = 1;
                continue;
            }
            if (this.fCurrentStep[i] >= steps.length || steps[this.fCurrentStep[i]].axis.type != 2) continue;
            int attrCount = attributes.getLength();
            if (attrCount > 0) {
                nodeTest = steps[this.fCurrentStep[i]].nodeTest;
                for (int aIndex = 0; aIndex < attrCount; ++aIndex) {
                    int j;
                    attributes.getName(aIndex, this.fQName);
                    if (!XPathMatcher.matches(nodeTest, this.fQName)) continue;
                    int n = i;
                    this.fCurrentStep[n] = this.fCurrentStep[n] + 1;
                    if (this.fCurrentStep[i] != steps.length) break;
                    this.fMatched[i] = 3;
                    for (j = 0; j < i && (this.fMatched[j] & 1) != 1; ++j) {
                    }
                    if (j != i) break;
                    AttributePSVI attrPSVI = (AttributePSVI)attributes.getAugmentations(aIndex).getItem("ATTRIBUTE_PSVI");
                    this.fMatchedString = attrPSVI.getActualNormalizedValue();
                    this.matched(this.fMatchedString, attrPSVI.getActualNormalizedValueType(), attrPSVI.getItemValueTypes(), false);
                    break;
                }
            }
            if ((this.fMatched[i] & 1) == 1) continue;
            if (this.fCurrentStep[i] > descendantStep) {
                this.fCurrentStep[i] = descendantStep;
                continue;
            }
            int n = i;
            this.fNoMatchDepth[n] = this.fNoMatchDepth[n] + 1;
        }
    }

    public void endElement(QName element, XSTypeDefinition type, boolean nillable, Object value, short valueType, ShortList itemValueType) {
        for (int i = 0; i < this.fLocationPaths.length; ++i) {
            int j;
            this.fCurrentStep[i] = this.fStepIndexes[i].pop();
            if (this.fNoMatchDepth[i] > 0) {
                int n = i;
                this.fNoMatchDepth[n] = this.fNoMatchDepth[n] - 1;
                continue;
            }
            for (j = 0; j < i && (this.fMatched[j] & 1) != 1; ++j) {
            }
            if (j < i || this.fMatched[j] == 0) continue;
            if ((this.fMatched[j] & 3) == 3) {
                this.fMatched[i] = 0;
                continue;
            }
            this.handleContent(type, nillable, value, valueType, itemValueType);
            this.fMatched[i] = 0;
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        String s = super.toString();
        int index2 = s.lastIndexOf(46);
        if (index2 != -1) {
            s = s.substring(index2 + 1);
        }
        str.append(s);
        for (int i = 0; i < this.fLocationPaths.length; ++i) {
            str.append('[');
            XPath.Step[] steps = this.fLocationPaths[i].steps;
            for (int j = 0; j < steps.length; ++j) {
                if (j == this.fCurrentStep[i]) {
                    str.append('^');
                }
                str.append(steps[j].toString());
                if (j >= steps.length - 1) continue;
                str.append('/');
            }
            if (this.fCurrentStep[i] == steps.length) {
                str.append('^');
            }
            str.append(']');
            str.append(',');
        }
        return str.toString();
    }

    private String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int length = s.length();
        block3: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    str.append("\\n");
                    continue block3;
                }
                default: {
                    str.append(c);
                }
            }
        }
        return str.toString();
    }

    private static boolean matches(XPath.NodeTest nodeTest, QName value) {
        if (nodeTest.type == 1) {
            return nodeTest.name.equals(value);
        }
        if (nodeTest.type == 4) {
            return nodeTest.name.uri == value.uri;
        }
        return true;
    }
}

