/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.filter.Converter;
import org.infinispan.metadata.Metadata;

public class FutureUpdate {
    public static final ValueExtractor VALUE_EXTRACTOR = new ValueExtractor();
    private final UUID uuid;
    private final Object value;

    public FutureUpdate(UUID uuid, Object value) {
        this.uuid = uuid;
        this.value = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FutureUpdate{");
        sb.append("uuid=").append(this.uuid);
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Object getValue() {
        return this.value;
    }

    public static class ValueExtractorExternalizer
    implements AdvancedExternalizer<ValueExtractor> {
        public Set<Class<? extends ValueExtractor>> getTypeClasses() {
            return Collections.singleton(ValueExtractor.class);
        }

        public Integer getId() {
            return 1205;
        }

        public void writeObject(ObjectOutput output, ValueExtractor object) throws IOException {
        }

        public ValueExtractor readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return VALUE_EXTRACTOR;
        }
    }

    public static class ValueExtractor
    implements Converter {
        private ValueExtractor() {
        }

        public Object convert(Object key, Object value, Metadata metadata) {
            return value instanceof FutureUpdate ? ((FutureUpdate)value).getValue() : value;
        }
    }

    public static class Externalizer
    implements AdvancedExternalizer<FutureUpdate> {
        public void writeObject(ObjectOutput output, FutureUpdate object) throws IOException {
            output.writeLong(object.uuid.getMostSignificantBits());
            output.writeLong(object.uuid.getLeastSignificantBits());
            output.writeObject(object.value);
        }

        public FutureUpdate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            long msb = input.readLong();
            long lsb = input.readLong();
            return new FutureUpdate(new UUID(msb, lsb), input.readObject());
        }

        public Set<Class<? extends FutureUpdate>> getTypeClasses() {
            return Collections.singleton(FutureUpdate.class);
        }

        public Integer getId() {
            return 1204;
        }
    }
}

