/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.logging.Logger;
import org.jboss.naming.remote.client.HaRemoteNamingStore;
import org.jboss.naming.remote.client.RemoteContext;
import org.jboss.naming.remote.client.RemoteNamingStore;
import org.jboss.naming.remote.client.ejb.EJBClientHandler;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

public class NamingStoreCache {
    private static final Logger logger = Logger.getLogger(NamingStoreCache.class);
    private final ConcurrentMap<CacheKey, CacheEntry> cache = new ConcurrentHashMap<CacheKey, CacheEntry>();

    public synchronized RemoteNamingStore getRemoteNamingStore(Endpoint clientEndpoint, String connectionURL, OptionMap connectOptions, CallbackHandler callbackHandler, long connectionTimeout, OptionMap channelCreationOptions, long channelCreationTimeoutInMillis, List<RemoteContext.CloseTask> contextCloseTasks, boolean randomServer) throws IOException, NamingException, URISyntaxException {
        return this.getRemoteNamingStore(clientEndpoint, connectionURL, connectOptions, callbackHandler, connectionTimeout, channelCreationOptions, channelCreationTimeoutInMillis, contextCloseTasks, randomServer, null);
    }

    public synchronized RemoteNamingStore getRemoteNamingStore(Endpoint clientEndpoint, String connectionURL, OptionMap connectOptions, CallbackHandler callbackHandler, long connectionTimeout, OptionMap channelCreationOptions, long channelCreationTimeoutInMillis, List<RemoteContext.CloseTask> contextCloseTasks, boolean randomServer, EJBClientHandler ejbClientHandler) throws IOException, NamingException, URISyntaxException {
        final CacheKey key = new CacheKey(clientEndpoint, callbackHandler, connectOptions, connectionURL, ejbClientHandler);
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(key);
        if (cacheEntry == null) {
            HaRemoteNamingStore store;
            if (connectionURL.contains(",")) {
                String[] urls = connectionURL.split(",");
                ArrayList<URI> connectionUris = new ArrayList<URI>(urls.length);
                for (String url : urls) {
                    connectionUris.add(new URI(url.trim()));
                }
                store = new HaRemoteNamingStore(channelCreationTimeoutInMillis, channelCreationOptions, connectionTimeout, callbackHandler, connectOptions, connectionUris, clientEndpoint, randomServer, ejbClientHandler);
            } else {
                store = new HaRemoteNamingStore(channelCreationTimeoutInMillis, channelCreationOptions, connectionTimeout, callbackHandler, connectOptions, Collections.singletonList(new URI(connectionURL.trim())), clientEndpoint, randomServer, ejbClientHandler);
            }
            cacheEntry = new CacheEntry(store);
            this.cache.put(key, cacheEntry);
        }
        contextCloseTasks.add(new RemoteContext.CloseTask(){

            @Override
            public void close(boolean isFinalize) {
                NamingStoreCache.this.release(key, isFinalize);
            }
        });
        cacheEntry.referenceCount.incrementAndGet();
        return cacheEntry.namingStore;
    }

    public synchronized void release(CacheKey connectionHash, boolean async) {
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(connectionHash);
        if (cacheEntry == null) {
            return;
        }
        if (cacheEntry.referenceCount.decrementAndGet() == 0) {
            try {
                if (async) {
                    cacheEntry.namingStore.closeAsync();
                } else {
                    cacheEntry.namingStore.close();
                }
            }
            catch (NamingException e) {
                throw new RuntimeException("Failed to close naming store", e);
            }
            finally {
                this.cache.remove(connectionHash);
            }
        }
    }

    public synchronized void shutdown() {
        for (Map.Entry entry : this.cache.entrySet()) {
            RemoteNamingStore namingStore = ((CacheEntry)entry.getValue()).namingStore;
            try {
                namingStore.close();
            }
            catch (Throwable t) {
                logger.debug((Object)"Failed to close naming store ", t);
            }
        }
    }

    private static void safeClose(Closeable closable) {
        try {
            closable.close();
        }
        catch (Throwable t) {
            logger.debug((Object)"Failed to close connection ", t);
        }
    }

    private static final class CacheKey {
        final Endpoint endpoint;
        final String destination;
        final OptionMap connectOptions;
        final CallbackHandler callbackHandler;
        final EJBClientHandler ejbClientHandler;

        private CacheKey(Endpoint endpoint, CallbackHandler callbackHandler, OptionMap connectOptions, String destination, EJBClientHandler ejbClientHandler) {
            this.endpoint = endpoint;
            this.callbackHandler = callbackHandler;
            this.connectOptions = connectOptions;
            this.destination = destination;
            this.ejbClientHandler = ejbClientHandler;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.callbackHandler != null ? !this.callbackHandler.equals(cacheKey.callbackHandler) : cacheKey.callbackHandler != null) {
                return false;
            }
            if (this.connectOptions != null ? !this.connectOptions.equals(cacheKey.connectOptions) : cacheKey.connectOptions != null) {
                return false;
            }
            if (this.destination != null ? !this.destination.equals(cacheKey.destination) : cacheKey.destination != null) {
                return false;
            }
            if (this.endpoint != null ? !this.endpoint.equals(cacheKey.endpoint) : cacheKey.endpoint != null) {
                return false;
            }
            return !(this.ejbClientHandler != null ? !this.ejbClientHandler.equals(cacheKey.ejbClientHandler) : cacheKey.ejbClientHandler != null);
        }

        public int hashCode() {
            int result = this.endpoint != null ? this.endpoint.hashCode() : 0;
            result = 31 * result + (this.destination != null ? this.destination.hashCode() : 0);
            result = 31 * result + (this.connectOptions != null ? this.connectOptions.hashCode() : 0);
            result = 31 * result + (this.callbackHandler != null ? this.callbackHandler.hashCode() : 0);
            result = 31 * result + (this.ejbClientHandler != null ? this.ejbClientHandler.hashCode() : 0);
            return result;
        }
    }

    private class CacheEntry {
        private final AtomicInteger referenceCount = new AtomicInteger(0);
        private final RemoteNamingStore namingStore;

        private CacheEntry(RemoteNamingStore namingStore) {
            this.namingStore = namingStore;
        }
    }
}

