/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.extension;

import java.util.HashMap;
import java.util.Map;

interface JAXRConstants {

    public static enum Element {
        UNKNOWN(null),
        CONNECTION_FACTORY("connection-factory"),
        PROPERTIES("properties"),
        PROPERTY("property"),
        JUDDI_SERVER("juddi-server");

        private final String name;
        private static final Map<String, Element> MAP;

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Element forName(String localName) {
            Element element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Element> map = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    public static enum Attribute {
        UNKNOWN(null),
        JNDI_NAME("jndi-name"),
        CLASS("class"),
        NAME("name"),
        VALUE("value"),
        PUBLISH_URL("publish-url"),
        QUERY_URL("query-url");

        private final String name;
        private static final Map<String, Attribute> MAP;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Attribute forName(String localName) {
            Attribute element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        public String toString() {
            return this.getLocalName();
        }

        static {
            HashMap<String, Attribute> map = new HashMap<String, Attribute>();
            for (Attribute element : Attribute.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    public static enum Namespace {
        UNKNOWN(null),
        JAXR_1_0("urn:jboss:domain:jaxr:1.0"),
        JAXR_1_1("urn:jboss:domain:jaxr:1.1");

        public static final Namespace CURRENT;
        private final String name;
        private static final Map<String, Namespace> MAP;

        private Namespace(String name) {
            this.name = name;
        }

        public String getUriString() {
            return this.name;
        }

        public static Namespace forUri(String uri) {
            Namespace element = MAP.get(uri);
            return element == null ? UNKNOWN : element;
        }

        static {
            CURRENT = JAXR_1_1;
            HashMap<String, Namespace> map = new HashMap<String, Namespace>();
            for (Namespace namespace : Namespace.values()) {
                String name = namespace.getUriString();
                if (name == null) continue;
                map.put(name, namespace);
            }
            MAP = map;
        }
    }
}

