/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit.validators;

import java.text.SimpleDateFormat;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SuffixValidator
extends ModelTypeValidator {
    private final boolean denySeconds;

    public SuffixValidator() {
        this(false, true);
    }

    public SuffixValidator(boolean nullable, boolean denySeconds) {
        super(ModelType.STRING, nullable);
        this.denySeconds = denySeconds;
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        super.validateParameter(parameterName, value);
        if (value.isDefined()) {
            String suffix = value.asString();
            try {
                if (this.denySeconds && (suffix.contains("s") || suffix.contains("S"))) {
                    throw DomainManagementLogger.ROOT_LOGGER.suffixContainsMillis(suffix);
                }
                new SimpleDateFormat(suffix);
            }
            catch (IllegalArgumentException e) {
                throw DomainManagementLogger.ROOT_LOGGER.invalidSuffix(suffix);
            }
        }
    }
}

