/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import org.infinispan.Cache;
import org.infinispan.io.GridFile;
import org.infinispan.io.GridOutputStream;

public class WritableGridFileChannel
implements WritableByteChannel {
    private final GridOutputStream gridOutputStream;
    private final WritableByteChannel delegate;

    WritableGridFileChannel(GridFile file, Cache<String, byte[]> cache, boolean append) {
        this.gridOutputStream = new GridOutputStream(file, append, cache);
        this.delegate = Channels.newChannel(this.gridOutputStream);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.checkOpen();
        return this.delegate.write(src);
    }

    public void flush() throws IOException {
        this.gridOutputStream.flush();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

