/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.common.beans.property.BeanUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modcluster.config.impl.ModClusterConfig;
import org.jboss.modcluster.load.LoadBalanceFactorProvider;
import org.jboss.modcluster.load.impl.DynamicLoadBalanceFactorProvider;
import org.jboss.modcluster.load.impl.SimpleLoadBalanceFactorProvider;
import org.jboss.modcluster.load.metric.LoadMetric;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.extension.mod_cluster.BoottimeHandlerProvider;
import org.wildfly.extension.mod_cluster.ContainerEventHandlerAdapterBuilder;
import org.wildfly.extension.mod_cluster.ContainerEventHandlerService;
import org.wildfly.extension.mod_cluster.CustomLoadMetricDefinition;
import org.wildfly.extension.mod_cluster.DynamicLoadProviderDefinition;
import org.wildfly.extension.mod_cluster.LoadMetricDefinition;
import org.wildfly.extension.mod_cluster.LoadMetricEnum;
import org.wildfly.extension.mod_cluster.ModClusterConfigAdd;
import org.wildfly.extension.mod_cluster.ModClusterConfigResourceDefinition;
import org.wildfly.extension.mod_cluster.ModClusterLogger;
import org.wildfly.extension.mod_cluster.ModClusterSSLResourceDefinition;

class ModClusterSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private static final OperationContext.AttachmentKey<Boolean> SUBSYSTEM_ADD_KEY = OperationContext.AttachmentKey.create(Boolean.class);
    static final ModClusterSubsystemAdd INSTANCE = new ModClusterSubsystemAdd();

    ModClusterSubsystemAdd() {
    }

    public void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        List modelNodes;
        String bindingRef;
        ServiceTarget target = context.getServiceTarget();
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        ModelNode modelConfig = fullModel.get(ModClusterConfigResourceDefinition.PATH.getKeyValuePair());
        ModClusterConfig config = this.getModClusterConfig(context, modelConfig);
        target.addService(ContainerEventHandlerService.CONFIG_SERVICE_NAME, (Service)new ValueService((Value)new ImmediateValue((Object)config))).setInitialMode(ServiceController.Mode.ACTIVE).install();
        HashSet<LoadMetric> metrics = new HashSet<LoadMetric>();
        LoadBalanceFactorProvider loadProvider = this.getModClusterLoadProvider(metrics, context, modelConfig);
        for (BoottimeHandlerProvider handler : ServiceLoader.load(BoottimeHandlerProvider.class, BoottimeHandlerProvider.class.getClassLoader())) {
            handler.performBoottime(metrics, context, operation, model);
        }
        String connector = ModClusterConfigResourceDefinition.CONNECTOR.resolveModelAttribute(context, modelConfig).asString();
        int statusInterval = ModClusterConfigResourceDefinition.STATUS_INTERVAL.resolveModelAttribute(context, modelConfig).asInt();
        InjectedValue socketBindingManager = new InjectedValue();
        ContainerEventHandlerService service = new ContainerEventHandlerService(config, loadProvider, (Value<SocketBindingManager>)socketBindingManager);
        ServiceBuilder builder = new AsynchronousServiceBuilder(ContainerEventHandlerService.SERVICE_NAME, (Service)service).build(target).addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, (Injector)socketBindingManager).setInitialMode(ServiceController.Mode.ACTIVE);
        ModelNode bindingRefNode = ModClusterConfigResourceDefinition.ADVERTISE_SOCKET.resolveModelAttribute(context, modelConfig);
        String string = bindingRef = bindingRefNode.isDefined() ? bindingRefNode.asString() : null;
        if (bindingRef != null) {
            builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingRef}), SocketBinding.class, service.getSocketBindingInjector());
        }
        List list = modelNodes = modelConfig.get("proxies").isDefined() ? modelConfig.get("proxies").asList() : null;
        if (modelNodes != null) {
            for (ModelNode node : modelNodes) {
                String ref = node.asString();
                builder.addDependency(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{ref}), OutboundSocketBinding.class, service.getOutboundSocketBindingInjector(ref));
            }
        }
        builder.install();
        for (ContainerEventHandlerAdapterBuilder adapterBuilder : ServiceLoader.load(ContainerEventHandlerAdapterBuilder.class, ContainerEventHandlerAdapterBuilder.class.getClassLoader())) {
            adapterBuilder.build(target, connector, statusInterval).setInitialMode(ServiceController.Mode.PASSIVE).install();
        }
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        if (operation.hasDefined("mod-cluster-config")) {
            PathAddress opAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
            PathAddress parent = opAddress.append(new PathElement[]{ModClusterConfigResourceDefinition.PATH});
            ModelNode targetOperation = Util.createAddOperation((PathAddress)parent);
            for (AttributeDefinition def : ModClusterConfigResourceDefinition.ATTRIBUTES) {
                def.validateAndSet(operation, targetOperation);
            }
            context.addStep(targetOperation, (OperationStepHandler)ModClusterConfigAdd.INSTANCE, OperationContext.Stage.MODEL, true);
        }
        context.attach(SUBSYSTEM_ADD_KEY, (Object)Boolean.TRUE);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    static boolean isActiveInContext(OperationContext context) {
        return context.getAttachment(SUBSYSTEM_ADD_KEY) != null;
    }

    private ModClusterConfig getModClusterConfig(OperationContext context, ModelNode model) throws OperationFailedException {
        ModClusterConfig config = new ModClusterConfig();
        config.setAdvertise(Boolean.valueOf(ModClusterConfigResourceDefinition.ADVERTISE.resolveModelAttribute(context, model).asBoolean()));
        if (model.get(ModClusterSSLResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
            config.setSsl(true);
            ModelNode ssl = model.get(ModClusterSSLResourceDefinition.PATH.getKeyValuePair());
            ModelNode keyAlias = ModClusterSSLResourceDefinition.KEY_ALIAS.resolveModelAttribute(context, ssl);
            ModelNode password = ModClusterSSLResourceDefinition.PASSWORD.resolveModelAttribute(context, ssl);
            if (keyAlias.isDefined()) {
                config.setSslKeyAlias(keyAlias.asString());
            }
            if (password.isDefined()) {
                config.setSslTrustStorePassword(password.asString());
                config.setSslKeyStorePassword(password.asString());
            }
            if (ssl.hasDefined("certificate-key-file")) {
                config.setSslKeyStore(ModClusterSSLResourceDefinition.CERTIFICATE_KEY_FILE.resolveModelAttribute(context, ssl).asString());
            }
            if (ssl.hasDefined("cipher-suite")) {
                config.setSslCiphers(ModClusterSSLResourceDefinition.CIPHER_SUITE.resolveModelAttribute(context, ssl).asString());
            }
            if (ssl.hasDefined("protocol")) {
                config.setSslProtocol(ModClusterSSLResourceDefinition.PROTOCOL.resolveModelAttribute(context, ssl).asString());
            }
            if (ssl.hasDefined("ca-certificate-file")) {
                config.setSslTrustStore(ModClusterSSLResourceDefinition.CA_CERTIFICATE_FILE.resolveModelAttribute(context, ssl).asString());
            }
            if (ssl.hasDefined("ca-revocation-url")) {
                config.setSslCrlFile(ModClusterSSLResourceDefinition.CA_REVOCATION_URL.resolveModelAttribute(context, ssl).asString());
            }
        }
        if (model.hasDefined("proxy-list")) {
            throw new OperationFailedException(ModClusterLogger.ROOT_LOGGER.proxyListNotAllowedInCurrentModel());
        }
        if (model.hasDefined("advertise-security-key")) {
            config.setAdvertiseSecurityKey(ModClusterConfigResourceDefinition.ADVERTISE_SECURITY_KEY.resolveModelAttribute(context, model).asString());
        }
        config.setProxyURL(ModClusterConfigResourceDefinition.PROXY_URL.resolveModelAttribute(context, model).asString());
        if (model.hasDefined("excluded-contexts")) {
            config.setExcludedContexts(ModClusterConfigResourceDefinition.EXCLUDED_CONTEXTS.resolveModelAttribute(context, model).asString().trim());
        }
        config.setAutoEnableContexts(ModClusterConfigResourceDefinition.AUTO_ENABLE_CONTEXTS.resolveModelAttribute(context, model).asBoolean());
        config.setStopContextTimeout(ModClusterConfigResourceDefinition.STOP_CONTEXT_TIMEOUT.resolveModelAttribute(context, model).asInt());
        config.setStopContextTimeoutUnit(TimeUnit.valueOf(ModClusterConfigResourceDefinition.STOP_CONTEXT_TIMEOUT.getMeasurementUnit().getName()));
        config.setSocketTimeout(ModClusterConfigResourceDefinition.SOCKET_TIMEOUT.resolveModelAttribute(context, model).asInt() * 1000);
        config.setStickySession(ModClusterConfigResourceDefinition.STICKY_SESSION.resolveModelAttribute(context, model).asBoolean());
        config.setStickySessionRemove(ModClusterConfigResourceDefinition.STICKY_SESSION_REMOVE.resolveModelAttribute(context, model).asBoolean());
        config.setStickySessionForce(ModClusterConfigResourceDefinition.STICKY_SESSION_FORCE.resolveModelAttribute(context, model).asBoolean());
        config.setWorkerTimeout(ModClusterConfigResourceDefinition.WORKER_TIMEOUT.resolveModelAttribute(context, model).asInt());
        config.setMaxAttempts(ModClusterConfigResourceDefinition.MAX_ATTEMPTS.resolveModelAttribute(context, model).asInt());
        config.setFlushPackets(ModClusterConfigResourceDefinition.FLUSH_PACKETS.resolveModelAttribute(context, model).asBoolean());
        config.setFlushWait(ModClusterConfigResourceDefinition.FLUSH_WAIT.resolveModelAttribute(context, model).asInt());
        config.setPing(ModClusterConfigResourceDefinition.PING.resolveModelAttribute(context, model).asInt());
        config.setSmax(ModClusterConfigResourceDefinition.SMAX.resolveModelAttribute(context, model).asInt());
        config.setTtl(ModClusterConfigResourceDefinition.TTL.resolveModelAttribute(context, model).asInt());
        config.setNodeTimeout(ModClusterConfigResourceDefinition.NODE_TIMEOUT.resolveModelAttribute(context, model).asInt());
        config.setSessionDrainingStrategy(ModClusterConfigResourceDefinition.SESSION_DRAINING_STRATEGY.resolveModelAttribute(context, model).asString());
        if (model.hasDefined("balancer")) {
            config.setBalancer(ModClusterConfigResourceDefinition.BALANCER.resolveModelAttribute(context, model).asString());
        }
        if (model.hasDefined("load-balancing-group")) {
            config.setLoadBalancingGroup(ModClusterConfigResourceDefinition.LOAD_BALANCING_GROUP.resolveModelAttribute(context, model).asString());
        }
        return config;
    }

    private LoadBalanceFactorProvider getModClusterLoadProvider(Set<LoadMetric> metrics, OperationContext context, ModelNode model) throws OperationFailedException {
        SimpleLoadBalanceFactorProvider load = null;
        if (model.hasDefined("simple-load-provider")) {
            int value = ModClusterConfigResourceDefinition.SIMPLE_LOAD_PROVIDER.resolveModelAttribute(context, model).asInt(1);
            SimpleLoadBalanceFactorProvider myload = new SimpleLoadBalanceFactorProvider();
            myload.setLoadBalanceFactor(value);
            load = myload;
        }
        if (model.get(DynamicLoadProviderDefinition.PATH.getKeyValuePair()).isDefined()) {
            ModelNode node = model.get(DynamicLoadProviderDefinition.PATH.getKeyValuePair());
            int decayFactor = DynamicLoadProviderDefinition.DECAY.resolveModelAttribute(context, node).asInt();
            int history = DynamicLoadProviderDefinition.HISTORY.resolveModelAttribute(context, node).asInt();
            if (node.hasDefined("load-metric")) {
                this.addLoadMetrics(metrics, node.get("load-metric"), context);
            }
            if (node.hasDefined("custom-load-metric")) {
                this.addLoadMetrics(metrics, node.get("custom-load-metric"), context);
            }
            if (!metrics.isEmpty()) {
                DynamicLoadBalanceFactorProvider loader = new DynamicLoadBalanceFactorProvider(metrics);
                loader.setDecayFactor(decayFactor);
                loader.setHistory(history);
                load = loader;
            }
        }
        if (load == null) {
            ModClusterLogger.ROOT_LOGGER.useDefaultLoadBalancer();
            SimpleLoadBalanceFactorProvider myload = new SimpleLoadBalanceFactorProvider();
            myload.setLoadBalanceFactor(1);
            load = myload;
        }
        return load;
    }

    private void addLoadMetrics(Set<LoadMetric> metrics, ModelNode nodes, OperationContext context) throws OperationFailedException {
        for (Property p : nodes.asPropertyList()) {
            ModelNode node = p.getValue();
            double capacity = LoadMetricDefinition.CAPACITY.resolveModelAttribute(context, node).asDouble();
            int weight = LoadMetricDefinition.WEIGHT.resolveModelAttribute(context, node).asInt();
            Map propertyMap = LoadMetricDefinition.PROPERTY.unwrap((ExpressionResolver)context, node);
            Class<LoadMetric> loadMetricClass = null;
            if (node.hasDefined("type")) {
                String type = LoadMetricDefinition.TYPE.resolveModelAttribute(context, node).asString();
                if (type.equals("mem")) {
                    ModClusterLogger.ROOT_LOGGER.unsupportedMetric(type);
                    continue;
                }
                LoadMetricEnum metric = LoadMetricEnum.forType(type);
                loadMetricClass = metric != null ? metric.getLoadMetricClass() : null;
            } else {
                String className = CustomLoadMetricDefinition.CLASS.resolveModelAttribute(context, node).asString();
                try {
                    loadMetricClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className).asSubclass(LoadMetric.class);
                }
                catch (ClassNotFoundException e) {
                    ModClusterLogger.ROOT_LOGGER.errorAddingMetrics(e);
                }
            }
            if (loadMetricClass == null) continue;
            try {
                LoadMetric metric = loadMetricClass.newInstance();
                metric.setCapacity(capacity);
                metric.setWeight(weight);
                if (propertyMap != null && !propertyMap.isEmpty()) {
                    Properties props = new Properties();
                    props.putAll((Map<?, ?>)propertyMap);
                    try {
                        BeanUtils.mapJavaBeanProperties((Object)metric, (Properties)props, (boolean)true);
                    }
                    catch (Exception ex) {
                        ModClusterLogger.ROOT_LOGGER.errorApplyingMetricProperties(ex, loadMetricClass.getCanonicalName());
                        continue;
                    }
                }
                metrics.add(metric);
            }
            catch (IllegalAccessException | InstantiationException e) {
                ModClusterLogger.ROOT_LOGGER.errorAddingMetrics(e);
            }
        }
    }
}

