/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportImpl;

class EventImpl
implements Event {
    Event.Type type = null;
    Object context;
    EventImpl next;

    EventImpl() {
    }

    void init(Event.Type type, Object context) {
        this.type = type;
        this.context = context;
    }

    void clear() {
        this.type = null;
        this.context = null;
    }

    @Override
    public Event.Type getType() {
        return this.type;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public void dispatch(Handler handler) {
        switch (this.type) {
            case CONNECTION_INIT: {
                handler.onConnectionInit(this);
                break;
            }
            case CONNECTION_LOCAL_OPEN: {
                handler.onConnectionLocalOpen(this);
                break;
            }
            case CONNECTION_REMOTE_OPEN: {
                handler.onConnectionRemoteOpen(this);
                break;
            }
            case CONNECTION_LOCAL_CLOSE: {
                handler.onConnectionLocalClose(this);
                break;
            }
            case CONNECTION_REMOTE_CLOSE: {
                handler.onConnectionRemoteClose(this);
                break;
            }
            case CONNECTION_BOUND: {
                handler.onConnectionBound(this);
                break;
            }
            case CONNECTION_UNBOUND: {
                handler.onConnectionUnbound(this);
                break;
            }
            case CONNECTION_FINAL: {
                handler.onConnectionFinal(this);
                break;
            }
            case SESSION_INIT: {
                handler.onSessionInit(this);
                break;
            }
            case SESSION_LOCAL_OPEN: {
                handler.onSessionLocalOpen(this);
                break;
            }
            case SESSION_REMOTE_OPEN: {
                handler.onSessionRemoteOpen(this);
                break;
            }
            case SESSION_LOCAL_CLOSE: {
                handler.onSessionLocalClose(this);
                break;
            }
            case SESSION_REMOTE_CLOSE: {
                handler.onSessionRemoteClose(this);
                break;
            }
            case SESSION_FINAL: {
                handler.onSessionFinal(this);
                break;
            }
            case LINK_INIT: {
                handler.onLinkInit(this);
                break;
            }
            case LINK_LOCAL_OPEN: {
                handler.onLinkLocalOpen(this);
                break;
            }
            case LINK_REMOTE_OPEN: {
                handler.onLinkRemoteOpen(this);
                break;
            }
            case LINK_LOCAL_DETACH: {
                handler.onLinkLocalDetach(this);
                break;
            }
            case LINK_REMOTE_DETACH: {
                handler.onLinkRemoteDetach(this);
                break;
            }
            case LINK_LOCAL_CLOSE: {
                handler.onLinkLocalClose(this);
                break;
            }
            case LINK_REMOTE_CLOSE: {
                handler.onLinkRemoteClose(this);
                break;
            }
            case LINK_FLOW: {
                handler.onLinkFlow(this);
                break;
            }
            case LINK_FINAL: {
                handler.onLinkFinal(this);
                break;
            }
            case DELIVERY: {
                handler.onDelivery(this);
                break;
            }
            case TRANSPORT: {
                handler.onTransport(this);
                break;
            }
            case TRANSPORT_ERROR: {
                handler.onTransportError(this);
                break;
            }
            case TRANSPORT_HEAD_CLOSED: {
                handler.onTransportHeadClosed(this);
                break;
            }
            case TRANSPORT_TAIL_CLOSED: {
                handler.onTransportTailClosed(this);
                break;
            }
            case TRANSPORT_CLOSED: {
                handler.onTransportClosed(this);
                break;
            }
            default: {
                handler.onUnhandled(this);
            }
        }
    }

    @Override
    public Connection getConnection() {
        if (this.context instanceof Connection) {
            return (Connection)this.context;
        }
        if (this.context instanceof Transport) {
            Transport transport = this.getTransport();
            if (transport == null) {
                return null;
            }
            return ((TransportImpl)transport).getConnectionImpl();
        }
        Session ssn = this.getSession();
        if (ssn == null) {
            return null;
        }
        return ssn.getConnection();
    }

    @Override
    public Session getSession() {
        if (this.context instanceof Session) {
            return (Session)this.context;
        }
        Link link = this.getLink();
        if (link == null) {
            return null;
        }
        return link.getSession();
    }

    @Override
    public Link getLink() {
        if (this.context instanceof Link) {
            return (Link)this.context;
        }
        Delivery dlv = this.getDelivery();
        if (dlv == null) {
            return null;
        }
        return dlv.getLink();
    }

    @Override
    public Delivery getDelivery() {
        if (this.context instanceof Delivery) {
            return (Delivery)this.context;
        }
        return null;
    }

    @Override
    public Transport getTransport() {
        if (this.context instanceof Transport) {
            return (Transport)this.context;
        }
        return null;
    }

    @Override
    public Event copy() {
        EventImpl newEvent = new EventImpl();
        newEvent.init(this.type, this.context);
        return newEvent;
    }

    public String toString() {
        return "EventImpl{type=" + (Object)((Object)this.type) + ", context=" + this.context + '}';
    }
}

