/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.internal.BaseRow;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;

public class Row
extends BaseRow
implements Serializable,
Cloneable {
    static final long serialVersionUID = 5047859032611314762L;
    private Object[] currentVals;
    private BitSet colsChanged;
    private boolean deleted;
    private boolean updated;
    private boolean inserted;
    private int numCols;

    public Row(int numCols) {
        this.origVals = new Object[numCols];
        this.currentVals = new Object[numCols];
        this.colsChanged = new BitSet(numCols);
        this.numCols = numCols;
    }

    public Row(int numCols, Object[] vals) {
        this.origVals = new Object[numCols];
        System.arraycopy(vals, 0, this.origVals, 0, numCols);
        this.currentVals = new Object[numCols];
        this.colsChanged = new BitSet(numCols);
        this.numCols = numCols;
    }

    public void initColumnObject(int idx, Object val) {
        this.origVals[idx - 1] = val;
    }

    @Override
    public void setColumnObject(int idx, Object val) {
        this.currentVals[idx - 1] = val;
        this.setColUpdated(idx - 1);
    }

    @Override
    public Object getColumnObject(int columnIndex) throws SQLException {
        if (this.getColUpdated(columnIndex - 1)) {
            return this.currentVals[columnIndex - 1];
        }
        return this.origVals[columnIndex - 1];
    }

    public boolean getColUpdated(int idx) {
        return this.colsChanged.get(idx);
    }

    public void setDeleted() {
        this.deleted = true;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void clearDeleted() {
        this.deleted = false;
    }

    public void setInserted() {
        this.inserted = true;
    }

    public boolean getInserted() {
        return this.inserted;
    }

    public void clearInserted() {
        this.inserted = false;
    }

    public boolean getUpdated() {
        return this.updated;
    }

    public void setUpdated() {
        for (int i = 0; i < this.numCols; ++i) {
            if (!this.getColUpdated(i)) continue;
            this.updated = true;
            return;
        }
    }

    private void setColUpdated(int idx) {
        this.colsChanged.set(idx);
    }

    public void clearUpdated() {
        this.updated = false;
        for (int i = 0; i < this.numCols; ++i) {
            this.currentVals[i] = null;
            this.colsChanged.clear(i);
        }
    }

    public void moveCurrentToOrig() {
        for (int i = 0; i < this.numCols; ++i) {
            if (!this.getColUpdated(i)) continue;
            this.origVals[i] = this.currentVals[i];
            this.currentVals[i] = null;
            this.colsChanged.clear(i);
        }
        this.updated = false;
    }

    public BaseRow getCurrentRow() {
        return null;
    }
}

