/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

class ConsoleVersion
implements Comparable<ConsoleVersion> {
    private final String name;
    private final int major;
    private final int minor;
    private final int micro;

    ConsoleVersion(String name) {
        this.name = name;
        String[] parts = name.split("\\.");
        int maj = -1;
        int min = 0;
        int mic = 0;
        if (parts.length < 4 && (maj = ConsoleVersion.getInt(parts[0])) > -1 && parts.length > 1) {
            min = ConsoleVersion.getInt(parts[1]);
            if (min > -1) {
                if (parts.length > 2 && (mic = ConsoleVersion.getInt(parts[2])) < 0) {
                    maj = -1;
                }
            } else {
                maj = -1;
            }
        }
        this.major = maj;
        this.minor = min;
        this.micro = mic;
    }

    private static int getInt(String part) {
        try {
            return Integer.valueOf(part);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ConsoleVersion && this.name.equals(((ConsoleVersion)obj).name);
    }

    @Override
    public int compareTo(ConsoleVersion o) {
        if (this.equals(o)) {
            return 0;
        }
        if ("main".equals(this.name)) {
            return 1;
        }
        if (this.major == -1) {
            return o.major == -1 ? this.name.compareTo(o.name) : 1;
        }
        int majorDiff = o.major - this.major;
        if (majorDiff != 0) {
            return majorDiff;
        }
        int minorDiff = o.minor - this.minor;
        if (minorDiff != 0) {
            return minorDiff;
        }
        return o.micro - this.micro;
    }
}

