/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.io;

import java.io.IOException;
import java.io.OutputStream;

public final class TeeOutputStream
extends OutputStream {
    private final OutputStream[] delegates;

    public TeeOutputStream(OutputStream first, OutputStream second, OutputStream ... others) {
        if (first == null || second == null) {
            throw new IllegalArgumentException();
        }
        if (others != null && others.length > 0) {
            for (OutputStream os : others) {
                if (os != null) continue;
                throw new IllegalArgumentException();
            }
        }
        int size = 2 + (others != null ? others.length : 0);
        this.delegates = new OutputStream[size];
        this.delegates[0] = first;
        this.delegates[1] = second;
        if (size > 2) {
            for (int i = 0; i < others.length; ++i) {
                this.delegates[2 + i] = others[i];
            }
        }
    }

    @Override
    public void write(int data) throws IOException {
        for (OutputStream delegate : this.delegates) {
            delegate.write(data);
        }
    }

    @Override
    public void write(byte[] data) throws IOException {
        for (OutputStream delegate : this.delegates) {
            delegate.write(data);
        }
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        for (OutputStream delegate : this.delegates) {
            delegate.write(data, offset, length);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream delegate : this.delegates) {
            delegate.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (OutputStream delegate : this.delegates) {
            delegate.close();
        }
    }
}

