/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sasl.localuser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.jboss.sasl.util.AbstractSaslParticipant;
import org.jboss.sasl.util.AbstractSaslServer;
import org.jboss.sasl.util.Charsets;
import org.jboss.sasl.util.SaslState;
import org.jboss.sasl.util.SaslStateContext;

public final class LocalUserServer
extends AbstractSaslServer
implements SaslServer {
    public static final String LOCAL_USER_USE_SECURE_RANDOM = "jboss.sasl.local-user.use-secure-random";
    public static final String LOCAL_USER_CHALLENGE_PATH = "jboss.sasl.local-user.challenge-path";
    public static final String DEFAULT_USER = "jboss.sasl.local-user.default-user";
    private static final byte UTF8NUL = 0;
    private volatile String authorizationId;
    private volatile File challengeFile;
    private final File basePath;
    private final String defaultUser;
    private final boolean useSecureRandom;

    LocalUserServer(String protocol, String serverName, Map<String, ?> props, CallbackHandler callbackHandler) {
        super("JBOSS-LOCAL-USER", protocol, serverName, callbackHandler);
        String value;
        this.basePath = props.containsKey(LOCAL_USER_CHALLENGE_PATH) ? new File(props.get(LOCAL_USER_CHALLENGE_PATH).toString()).getAbsoluteFile() : ((value = LocalUserServer.getProperty(LOCAL_USER_CHALLENGE_PATH)) != null ? new File(value).getAbsoluteFile() : new File(LocalUserServer.getProperty("java.io.tmpdir")));
        String useSecureRandomObj = null;
        useSecureRandomObj = props.containsKey(LOCAL_USER_USE_SECURE_RANDOM) ? props.get(LOCAL_USER_USE_SECURE_RANDOM) : LocalUserServer.getProperty(LOCAL_USER_USE_SECURE_RANDOM);
        this.useSecureRandom = useSecureRandomObj != null ? (useSecureRandomObj instanceof Boolean ? (Boolean)((Object)useSecureRandomObj) : (useSecureRandomObj instanceof String ? Boolean.parseBoolean(useSecureRandomObj) : true)) : true;
        this.defaultUser = props.containsKey(DEFAULT_USER) ? props.get(DEFAULT_USER) : null;
    }

    private static String getProperty(final String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(name);
                }
            });
        }
        return System.getProperty(name);
    }

    private Random getRandom() {
        if (this.useSecureRandom) {
            return new SecureRandom();
        }
        return new Random();
    }

    @Override
    public void init() {
        this.getContext().setNegotiationState(new SaslState(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] evaluateMessage(SaslStateContext context, byte[] message) throws SaslException {
                byte[] bytes;
                FileOutputStream fos;
                if (message.length == 0) {
                    return AbstractSaslParticipant.NO_BYTES;
                }
                if (message.length == 1 && message[0] == 0) {
                    LocalUserServer.this.authorizationId = null;
                } else {
                    LocalUserServer.this.authorizationId = new String(message, Charsets.UTF_8);
                }
                Random random = LocalUserServer.this.getRandom();
                try {
                    LocalUserServer.this.challengeFile = File.createTempFile("local", ".challenge", LocalUserServer.this.basePath);
                }
                catch (IOException e) {
                    throw new SaslException("Failed to create challenge file", e);
                }
                try {
                    fos = new FileOutputStream(LocalUserServer.this.challengeFile);
                }
                catch (FileNotFoundException e) {
                    throw new SaslException("Failed to create challenge file", e);
                }
                boolean ok = false;
                try {
                    bytes = new byte[8];
                    random.nextBytes(bytes);
                    try {
                        fos.write(bytes);
                        fos.close();
                        ok = true;
                    }
                    catch (IOException e) {
                        throw new SaslException("Failed to create challenge file", e);
                    }
                }
                finally {
                    if (!ok) {
                        LocalUserServer.this.deleteChallenge();
                    }
                    try {
                        fos.close();
                    }
                    catch (Throwable ignored) {}
                }
                String path = LocalUserServer.this.challengeFile.getAbsolutePath();
                byte[] response = new byte[Charsets.encodedLengthOf(path)];
                Charsets.encodeTo(path, response, 0);
                LocalUserServer.this.getContext().setNegotiationState(new SaslState(){

                    @Override
                    public byte[] evaluateMessage(SaslStateContext context, byte[] message) throws SaslException {
                        String authenticationRealm;
                        String authenticationId;
                        LocalUserServer.this.deleteChallenge();
                        int length = message.length;
                        if (length < 8) {
                            throw new SaslException("Invalid response");
                        }
                        if (!Arrays.equals(bytes, Arrays.copyOf(message, 8))) {
                            throw new SaslException("Invalid response");
                        }
                        int firstMarker = Charsets.indexOf(message, 0, 8);
                        if (firstMarker > -1) {
                            authenticationId = new String(message, 8, firstMarker - 8, Charsets.UTF_8);
                            int secondMarker = Charsets.indexOf(message, 0, firstMarker + 1);
                            authenticationRealm = secondMarker > -1 ? new String(message, firstMarker + 1, secondMarker - firstMarker - 1, Charsets.UTF_8) : null;
                        } else {
                            authenticationId = null;
                            authenticationRealm = null;
                        }
                        if (authenticationId == null || authenticationId.length() == 0) {
                            authenticationId = LocalUserServer.this.defaultUser;
                        }
                        if (authenticationId == null) {
                            throw new SaslException("No authentication ID given");
                        }
                        if (LocalUserServer.this.authorizationId == null) {
                            LocalUserServer.this.authorizationId = authenticationId;
                        }
                        NameCallback nameCallback = new NameCallback("User name", authenticationId);
                        AuthorizeCallback authorizeCallback = new AuthorizeCallback(authenticationId, LocalUserServer.this.authorizationId);
                        if (authenticationRealm == null) {
                            LocalUserServer.this.handleCallbacks(new Callback[]{nameCallback, authorizeCallback});
                        } else {
                            RealmCallback realmCallback = new RealmCallback("User realm", authenticationRealm);
                            LocalUserServer.this.handleCallbacks(new Callback[]{realmCallback, nameCallback, authorizeCallback});
                        }
                        if (!authorizeCallback.isAuthorized()) {
                            throw new SaslException("User " + LocalUserServer.this.authorizationId + " is not authorized");
                        }
                        context.negotiationComplete();
                        return null;
                    }
                });
                return response;
            }
        });
    }

    @Override
    public String getAuthorizationID() {
        if (this.isComplete()) {
            return this.authorizationId;
        }
        throw new IllegalStateException("JBOSS-LOCAL-USER server negotiation not complete");
    }

    private void deleteChallenge() {
        if (this.challengeFile != null) {
            this.challengeFile.delete();
            this.challengeFile = null;
        }
    }

    @Override
    public void dispose() throws SaslException {
        super.dispose();
        this.deleteChallenge();
    }

    protected void finalize() throws Throwable {
        this.deleteChallenge();
    }
}

