/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class BinaryKeyedJDBCStoreBuilder
extends JDBCStoreBuilder<JdbcBinaryStoreConfiguration, JdbcBinaryStoreConfigurationBuilder> {
    private final InjectedValue<TableManipulationConfiguration> table = new InjectedValue();
    private final String containerName;
    private final String cacheName;
    private volatile JdbcBinaryStoreConfigurationBuilder builder;

    BinaryKeyedJDBCStoreBuilder(String containerName, String cacheName) {
        super(JdbcBinaryStoreConfigurationBuilder.class, containerName, cacheName);
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        return super.build(target).addDependency(CacheComponent.BINARY_TABLE.getServiceName(this.containerName, this.cacheName), TableManipulationConfiguration.class, this.table);
    }

    @Override
    public PersistenceConfiguration getValue() {
        this.builder.table().read((TableManipulationConfiguration)this.table.getValue());
        return super.getValue();
    }

    @Override
    JdbcBinaryStoreConfigurationBuilder createStore(OperationContext context, ModelNode model) throws OperationFailedException {
        this.builder = (JdbcBinaryStoreConfigurationBuilder)super.createStore(context, model);
        return this.builder;
    }
}

