/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.management.JMException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientLifeCycleListener;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;
import org.apache.cxf.endpoint.ServerLifeCycleManager;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.Service;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.addressing.ObjectFactory;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.rm.BindingFaultFactory;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.ManagedRMManager;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.Proxy;
import org.apache.cxf.ws.rm.RM10Constants;
import org.apache.cxf.ws.rm.RM11Constants;
import org.apache.cxf.ws.rm.RMConfiguration;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.RetransmissionQueue;
import org.apache.cxf.ws.rm.RewindableInputStream;
import org.apache.cxf.ws.rm.SequenceIdentifierGenerator;
import org.apache.cxf.ws.rm.Servant;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.SourceSequence;
import org.apache.cxf.ws.rm.WrappedEndpoint;
import org.apache.cxf.ws.rm.manager.AcksPolicyType;
import org.apache.cxf.ws.rm.manager.DeliveryAssuranceType;
import org.apache.cxf.ws.rm.manager.DestinationPolicyType;
import org.apache.cxf.ws.rm.manager.RM10AddressingNamespaceType;
import org.apache.cxf.ws.rm.manager.SequenceTerminationPolicyType;
import org.apache.cxf.ws.rm.manager.SourcePolicyType;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.policy.RMPolicyUtilities;
import org.apache.cxf.ws.rm.soap.RetransmissionQueueImpl;
import org.apache.cxf.ws.rm.soap.SoapFaultFactory;
import org.apache.cxf.ws.rm.v200702.CloseSequenceType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceType;
import org.apache.cxf.ws.rmp.v200502.RMAssertion;

public class RMManager {
    public static final String WSRM_VERSION_PROPERTY = "org.apache.cxf.ws.rm.namespace";
    public static final String WSRM_WSA_VERSION_PROPERTY = "org.apache.cxf.ws.rm.wsa-namespace";
    public static final String WSRM_LAST_MESSAGE_PROPERTY = "org.apache.cxf.ws.rm.last-message";
    public static final String WSRM_INACTIVITY_TIMEOUT_PROPERTY = "org.apache.cxf.ws.rm.inactivity-timeout";
    public static final String WSRM_RETRANSMISSION_INTERVAL_PROPERTY = "org.apache.cxf.ws.rm.retransmission-interval";
    public static final String WSRM_EXPONENTIAL_BACKOFF_PROPERTY = "org.apache.cxf.ws.rm.exponential-backoff";
    public static final String WSRM_ACKNOWLEDGEMENT_INTERVAL_PROPERTY = "org.apache.cxf.ws.rm.acknowledgement-interval";
    private static final Logger LOG = LogUtils.getL7dLogger(RMManager.class);
    private static final String WSRM_RETRANSMIT_CHAIN = RMManager.class.getName() + ".retransmitChain";
    private Bus bus;
    private RMStore store;
    private SequenceIdentifierGenerator idGenerator;
    private RetransmissionQueue retransmissionQueue;
    private Map<Endpoint, RMEndpoint> reliableEndpoints = new ConcurrentHashMap<Endpoint, RMEndpoint>();
    private AtomicReference<Timer> timer = new AtomicReference();
    private RMConfiguration configuration;
    private SourcePolicyType sourcePolicy;
    private DestinationPolicyType destinationPolicy;
    private InstrumentationManager instrumentationManager;
    private ManagedRMManager managedManager;

    public void startServer(Server server) {
        this.recoverReliableEndpoint(server.getEndpoint(), null);
    }

    public void stopServer(Server server) {
    }

    public void clientCreated(Client client) {
        if (null == this.store || null == this.retransmissionQueue) {
            return;
        }
        String id = RMUtils.getEndpointIdentifier(client.getEndpoint(), this.getBus());
        Collection<SourceSequence> sss = this.store.getSourceSequences(id);
        if (null == sss || 0 == sss.size()) {
            return;
        }
        LOG.log(Level.FINE, "Number of source sequences: {0}", sss.size());
        this.recoverReliableEndpoint(client.getEndpoint(), client.getConduit());
    }

    public void clientDestroyed(Client client) {
    }

    public void setRMNamespace(String uri) {
        this.getConfiguration().setRMNamespace(uri);
    }

    public void setRM10AddressingNamespace(RM10AddressingNamespaceType addrns) {
        this.getConfiguration().setRM10AddressingNamespace(addrns.getUri());
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
        if (null != this.bus) {
            this.bus.setExtension((Object)this, RMManager.class);
        }
    }

    public RMStore getStore() {
        return this.store;
    }

    public void setStore(RMStore s) {
        this.store = s;
    }

    public RetransmissionQueue getRetransmissionQueue() {
        return this.retransmissionQueue;
    }

    public void setRetransmissionQueue(RetransmissionQueue rq) {
        this.retransmissionQueue = rq;
    }

    public SequenceIdentifierGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(SequenceIdentifierGenerator generator) {
        this.idGenerator = generator;
    }

    private Timer getTimer(boolean create) {
        Timer newt;
        Timer ret = this.timer.get();
        if (ret == null && create && !this.timer.compareAndSet(null, newt = new Timer("RMManager-Timer-" + System.identityHashCode(this), true))) {
            newt.cancel();
        }
        return this.timer.get();
    }

    public Timer getTimer() {
        return this.getTimer(true);
    }

    public BindingFaultFactory getBindingFaultFactory(Binding binding) {
        return new SoapFaultFactory(binding);
    }

    public void setDeliveryAssurance(DeliveryAssuranceType dat) {
        RMConfiguration cfg = this.getConfiguration();
        cfg.setInOrder(dat.isSetInOrder());
        RMConfiguration.DeliveryAssurance da = null;
        if (dat.isSetExactlyOnce() || dat.isSetAtLeastOnce() && dat.isSetAtMostOnce()) {
            da = RMConfiguration.DeliveryAssurance.EXACTLY_ONCE;
        } else if (dat.isSetAtLeastOnce()) {
            da = RMConfiguration.DeliveryAssurance.AT_LEAST_ONCE;
        } else if (dat.isSetAtMostOnce()) {
            da = RMConfiguration.DeliveryAssurance.AT_MOST_ONCE;
        }
        cfg.setDeliveryAssurance(da);
    }

    public DestinationPolicyType getDestinationPolicy() {
        return this.destinationPolicy;
    }

    public void setDestinationPolicy(DestinationPolicyType destinationPolicy) {
        this.destinationPolicy = destinationPolicy;
    }

    public RMConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.setConfiguration(new RMConfiguration());
        }
        return this.configuration;
    }

    public void setConfiguration(RMConfiguration configuration) {
        if (configuration.getBaseRetransmissionInterval() == null) {
            Long value = Long.valueOf("3000");
            configuration.setBaseRetransmissionInterval(value);
        }
        if (configuration.getRMNamespace() == null) {
            configuration.setRMNamespace("http://schemas.xmlsoap.org/ws/2005/02/rm");
        }
        this.configuration = configuration;
    }

    public RMConfiguration getEffectiveConfiguration(Message msg) {
        return RMPolicyUtilities.getRMConfiguration(this.getConfiguration(), msg);
    }

    public void setRMAssertion(RMAssertion rma) {
        this.setConfiguration(RMPolicyUtilities.intersect(rma, this.getConfiguration()));
    }

    public SourcePolicyType getSourcePolicy() {
        return this.sourcePolicy;
    }

    public void setSourcePolicy(SourcePolicyType sp) {
        if (null == sp) {
            sp = new SourcePolicyType();
        }
        if (sp.getSequenceTerminationPolicy() == null) {
            SequenceTerminationPolicyType term = new SequenceTerminationPolicyType();
            term.setTerminateOnShutdown(true);
            sp.setSequenceTerminationPolicy(term);
        }
        this.sourcePolicy = sp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMEndpoint getReliableEndpoint(Message message) throws RMException {
        RMEndpoint rme;
        Boolean exponential;
        Long interval;
        Long timeout;
        AddressingProperties maps;
        String addrUri;
        RMProperties rmps;
        String rmUri;
        Endpoint endpoint = message.getExchange().getEndpoint();
        QName name = endpoint.getEndpointInfo().getName();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Getting RMEndpoint for endpoint with info: " + name);
        }
        if (name.equals(RM10Constants.PORT_NAME) || name.equals(RM11Constants.PORT_NAME)) {
            WrappedEndpoint wrappedEndpoint = (WrappedEndpoint)endpoint;
            endpoint = wrappedEndpoint.getWrappedEndpoint();
        }
        if ((rmUri = (String)message.getContextualProperty(WSRM_VERSION_PROPERTY)) == null && (rmps = RMContextUtils.retrieveRMProperties(message, false)) != null) {
            rmUri = rmps.getNamespaceURI();
        }
        if ((addrUri = (String)message.getContextualProperty(WSRM_WSA_VERSION_PROPERTY)) == null && (maps = ContextUtils.retrieveMAPs((Message)message, (boolean)false, (boolean)false, (boolean)false)) != null) {
            addrUri = maps.getNamespaceURI();
        }
        RMConfiguration config = this.getConfiguration();
        if (rmUri != null) {
            config.setRMNamespace(rmUri);
            ProtocolVariation protocol = ProtocolVariation.findVariant(rmUri, addrUri);
            if (protocol == null) {
                org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("UNSUPPORTED_NAMESPACE", LOG, new Object[]{addrUri, rmUri});
                LOG.log(Level.INFO, msg.toString());
                throw new RMException(msg);
            }
        }
        if (addrUri != null) {
            config.setRM10AddressingNamespace(addrUri);
        }
        if ((timeout = (Long)message.getContextualProperty(WSRM_INACTIVITY_TIMEOUT_PROPERTY)) != null) {
            config.setInactivityTimeout(timeout);
        }
        if ((interval = (Long)message.getContextualProperty(WSRM_RETRANSMISSION_INTERVAL_PROPERTY)) != null) {
            config.setBaseRetransmissionInterval(interval);
        }
        if ((exponential = (Boolean)message.getContextualProperty(WSRM_EXPONENTIAL_BACKOFF_PROPERTY)) != null) {
            config.setExponentialBackoff(exponential);
        }
        if ((interval = (Long)message.getContextualProperty(WSRM_ACKNOWLEDGEMENT_INTERVAL_PROPERTY)) != null) {
            config.setAcknowledgementInterval(interval);
        }
        if (null == (rme = this.reliableEndpoints.get(endpoint))) {
            Endpoint endpoint2 = endpoint;
            synchronized (endpoint2) {
                Endpoint ei;
                rme = this.reliableEndpoints.get(endpoint);
                if (rme != null) {
                    return rme;
                }
                rme = this.createReliableEndpoint(endpoint);
                org.apache.cxf.transport.Destination destination = message.getExchange().getDestination();
                EndpointReferenceType replyTo = null;
                if (null != destination) {
                    AddressingProperties maps2 = RMContextUtils.retrieveMAPs(message, false, false);
                    replyTo = maps2.getReplyTo();
                }
                org.apache.cxf.transport.Destination dest = (ei = message.getExchange().getEndpoint()) == null ? null : (org.apache.cxf.transport.Destination)ei.getEndpointInfo().getProperty(MAPAggregator.DECOUPLED_DESTINATION, org.apache.cxf.transport.Destination.class);
                config = RMPolicyUtilities.getRMConfiguration(config, message);
                rme.initialise(config, message.getExchange().getConduit(message), replyTo, dest, message);
                this.reliableEndpoints.put(endpoint, rme);
                LOG.fine("Created new RMEndpoint.");
            }
        }
        return rme;
    }

    public Destination getDestination(Message message) throws RMException {
        RMEndpoint rme = this.getReliableEndpoint(message);
        if (null != rme) {
            return rme.getDestination();
        }
        return null;
    }

    public Source getSource(Message message) throws RMException {
        RMEndpoint rme = this.getReliableEndpoint(message);
        if (null != rme) {
            return rme.getSource();
        }
        return null;
    }

    public SourceSequence getSequence(Identifier inSeqId, Message message, AddressingProperties maps) throws RMException {
        Source source = this.getSource(message);
        SourceSequence seq = source.getCurrent(inSeqId);
        RMConfiguration config = this.getEffectiveConfiguration(message);
        if (null == seq || seq.isExpired()) {
            EndpointReferenceType to = null;
            boolean isServer = RMContextUtils.isServerSide(message);
            EndpointReferenceType acksTo = null;
            RelatesToType relatesTo = null;
            if (isServer) {
                AddressingProperties inMaps = RMContextUtils.retrieveMAPs(message, false, false);
                inMaps.exposeAs(config.getAddressingNamespace());
                acksTo = RMUtils.createReference(inMaps.getTo().getValue());
                to = inMaps.getReplyTo();
                source.getReliableEndpoint().getServant().setUnattachedIdentifier(inSeqId);
                relatesTo = new ObjectFactory().createRelatesToType();
                Destination destination = this.getDestination(message);
                DestinationSequence inSeq = inSeqId == null ? null : destination.getSequence(inSeqId);
                relatesTo.setValue(inSeq != null ? inSeq.getCorrelationID() : null);
            } else {
                to = RMUtils.createReference(maps.getTo().getValue());
                acksTo = maps.getReplyTo();
                if (RMUtils.getAddressingConstants().getNoneURI().equals(acksTo.getAddress().getValue())) {
                    Endpoint ei = message.getExchange().getEndpoint();
                    org.apache.cxf.transport.Destination dest = ei == null ? null : (org.apache.cxf.transport.Destination)ei.getEndpointInfo().getProperty(MAPAggregator.DECOUPLED_DESTINATION, org.apache.cxf.transport.Destination.class);
                    acksTo = null == dest ? RMUtils.createAnonymousReference() : dest.getAddress();
                }
            }
            if (ContextUtils.isGenericAddress((EndpointReferenceType)to)) {
                org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("CREATE_SEQ_ANON_TARGET", LOG, new Object[]{to != null && to.getAddress() != null ? to.getAddress().getValue() : null});
                LOG.log(Level.INFO, msg.toString());
                throw new RMException(msg);
            }
            Proxy proxy = source.getReliableEndpoint().getProxy();
            ProtocolVariation protocol = config.getProtocolVariation();
            ExchangeImpl exchange = new ExchangeImpl();
            HashMap<String, Object> context = new HashMap<String, Object>(16);
            for (String key : message.getContextualPropertyKeys()) {
                if (!key.startsWith("ws-security")) continue;
                context.put(key, message.getContextualProperty(key));
            }
            CreateSequenceResponseType createResponse = proxy.createSequence(acksTo, relatesTo, isServer, protocol, (Exchange)exchange, context);
            if (!isServer) {
                Servant servant = source.getReliableEndpoint().getServant();
                servant.createSequenceResponse(createResponse, protocol);
                Exchange appex = message.getExchange();
                if (appex.get((Object)"ws-security.token") == null) {
                    appex.put((Object)"ws-security.token", exchange.get((Object)"ws-security.token"));
                    appex.put((Object)"ws-security.token.id", exchange.get((Object)"ws-security.token.id"));
                }
            }
            seq = source.awaitCurrent(inSeqId);
            seq.setTarget(to);
        }
        return seq;
    }

    @PreDestroy
    public void shutdown() {
        Timer t;
        if (this.reliableEndpoints.size() > 0) {
            LOG.log(Level.FINE, "Shutting down RMManager with {0} remaining endpoints.", new Object[]{this.reliableEndpoints.size()});
            for (RMEndpoint rme : this.reliableEndpoints.values()) {
                rme.shutdown();
            }
        }
        if ((t = this.getTimer(false)) != null) {
            t.purge();
            t.cancel();
        }
    }

    void shutdownReliableEndpoint(Endpoint e) {
        RMEndpoint rme = this.reliableEndpoints.get(e);
        if (rme == null) {
            return;
        }
        rme.shutdown();
        Timer t = this.getTimer(false);
        if (t != null) {
            t.purge();
        }
        this.reliableEndpoints.remove(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recoverReliableEndpoint(Endpoint endpoint, Conduit conduit) {
        if (null == this.store || null == this.retransmissionQueue) {
            return;
        }
        String id = RMUtils.getEndpointIdentifier(endpoint, this.getBus());
        Collection<SourceSequence> sss = this.store.getSourceSequences(id);
        Collection<DestinationSequence> dss = this.store.getDestinationSequences(id);
        if (!(null != sss && 0 != sss.size() || null != dss && 0 != dss.size())) {
            return;
        }
        LOG.log(Level.FINE, "Number of source sequences: {0}", sss.size());
        LOG.log(Level.FINE, "Number of destination sequences: {0}", dss.size());
        LOG.log(Level.FINE, "Recovering {0} endpoint with id: {1}", new Object[]{null == conduit ? "client" : "server", id});
        RMEndpoint rme = this.createReliableEndpoint(endpoint);
        rme.initialise(this.getConfiguration(), conduit, null, null, null);
        Map<Endpoint, RMEndpoint> map = this.reliableEndpoints;
        synchronized (map) {
            this.reliableEndpoints.put(endpoint, rme);
        }
        for (SourceSequence ss : sss) {
            this.recoverSourceSequence(endpoint, conduit, rme.getSource(), ss);
        }
        for (DestinationSequence ds : dss) {
            this.reconverDestinationSequence(endpoint, conduit, rme.getDestination(), ds);
        }
        this.retransmissionQueue.start();
    }

    private void recoverSourceSequence(Endpoint endpoint, Conduit conduit, Source s, SourceSequence ss) {
        Collection<RMMessage> ms = this.store.getMessages(ss.getIdentifier(), true);
        if (null == ms || 0 == ms.size()) {
            this.store.removeSourceSequence(ss.getIdentifier());
            return;
        }
        LOG.log(Level.FINE, "Number of messages in sequence: {0}", ms.size());
        s.addSequence(ss, false);
        if (s.getAssociatedSequence(null) == null && !ss.isExpired() && !ss.isLastMessage()) {
            s.setCurrent(ss);
        }
        for (RMMessage m : ms) {
            MessageImpl message = new MessageImpl();
            ExchangeImpl exchange = new ExchangeImpl();
            message.setExchange((Exchange)exchange);
            exchange.setOutMessage((Message)message);
            if (null != conduit) {
                exchange.setConduit(conduit);
                message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
            }
            exchange.put(Endpoint.class, (Object)endpoint);
            exchange.put(Service.class, (Object)endpoint.getService());
            exchange.put(Binding.class, (Object)endpoint.getBinding());
            exchange.put(Bus.class, (Object)this.bus);
            SequenceType st = new SequenceType();
            st.setIdentifier(ss.getIdentifier());
            st.setMessageNumber(m.getMessageNumber());
            RMProperties rmps = new RMProperties();
            rmps.setSequence(st);
            rmps.exposeAs(ss.getProtocol().getWSRMNamespace());
            if (ss.isLastMessage() && ss.getCurrentMessageNr() == m.getMessageNumber()) {
                CloseSequenceType close = new CloseSequenceType();
                close.setIdentifier(ss.getIdentifier());
                rmps.setCloseSequence(close);
            }
            RMContextUtils.storeRMProperties((Message)message, rmps, true);
            if (null == conduit) {
                String to = m.getTo();
                AddressingProperties maps = new AddressingProperties();
                maps.setTo(RMUtils.createReference(to));
                RMContextUtils.storeMAPs(maps, (Message)message, true, false);
            }
            try {
                message.put((Object)"org.apache.cxf.ws.rm.content", (Object)RewindableInputStream.makeRewindable(m.getContent()));
                RMContextUtils.setProtocolVariation((Message)message, ss.getProtocol());
                this.retransmissionQueue.addUnacknowledged((Message)message);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Error reading persisted message data", e);
            }
        }
    }

    private void reconverDestinationSequence(Endpoint endpoint, Conduit conduit, Destination d, DestinationSequence ds) {
        d.addSequence(ds, false);
    }

    RMEndpoint createReliableEndpoint(final Endpoint endpoint) {
        endpoint.addCleanupHook(new Closeable(){

            @Override
            public void close() throws IOException {
                RMManager.this.shutdownReliableEndpoint(endpoint);
            }
        });
        return new RMEndpoint(this, endpoint);
    }

    public void init(Bus b) {
        this.setBus(b);
        this.initialise();
        this.registerListeners();
    }

    @PostConstruct
    void initialise() {
        RMConfiguration.DeliveryAssurance da;
        if (this.configuration == null) {
            this.getConfiguration().setExponentialBackoff(true);
        }
        if ((da = this.configuration.getDeliveryAssurance()) == null) {
            this.configuration.setDeliveryAssurance(RMConfiguration.DeliveryAssurance.AT_LEAST_ONCE);
        }
        if (null == this.sourcePolicy) {
            this.setSourcePolicy(null);
        }
        if (null == this.destinationPolicy) {
            DestinationPolicyType dp = new DestinationPolicyType();
            dp.setAcksPolicy(new AcksPolicyType());
            this.setDestinationPolicy(dp);
        }
        if (null == this.retransmissionQueue) {
            this.retransmissionQueue = new RetransmissionQueueImpl(this);
        }
        if (null == this.idGenerator) {
            this.idGenerator = new DefaultSequenceIdentifierGenerator();
        }
        if (null != this.bus) {
            this.managedManager = new ManagedRMManager(this);
            this.instrumentationManager = (InstrumentationManager)this.bus.getExtension(InstrumentationManager.class);
            if (this.instrumentationManager != null) {
                try {
                    this.instrumentationManager.register((ManagedComponent)this.managedManager);
                }
                catch (JMException jmex) {
                    LOG.log(Level.WARNING, "Registering ManagedRMManager failed.", jmex);
                }
            }
        }
    }

    @PostConstruct
    void registerListeners() {
        ClientLifeCycleManager clm;
        if (null == this.bus) {
            return;
        }
        ServerLifeCycleManager slm = (ServerLifeCycleManager)this.bus.getExtension(ServerLifeCycleManager.class);
        if (null != slm) {
            slm.registerListener(new ServerLifeCycleListener(){

                public void startServer(Server server) {
                    RMManager.this.startServer(server);
                }

                public void stopServer(Server server) {
                    RMManager.this.stopServer(server);
                }
            });
        }
        if (null != (clm = (ClientLifeCycleManager)this.bus.getExtension(ClientLifeCycleManager.class))) {
            clm.registerListener(new ClientLifeCycleListener(){

                public void clientCreated(Client client) {
                    RMManager.this.clientCreated(client);
                }

                public void clientDestroyed(Client client) {
                    RMManager.this.clientDestroyed(client);
                }
            });
        }
    }

    Map<Endpoint, RMEndpoint> getReliableEndpointsMap() {
        return this.reliableEndpoints;
    }

    void setReliableEndpointsMap(Map<Endpoint, RMEndpoint> map) {
        this.reliableEndpoints = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeInterceptorChain(Message msg) {
        Endpoint ep;
        Endpoint endpoint = ep = msg.getExchange().getEndpoint();
        synchronized (endpoint) {
            if (ep.get((Object)WSRM_RETRANSMIT_CHAIN) == null) {
                LOG.info("Setting retransmit chain from message");
                PhaseInterceptorChain chain = (PhaseInterceptorChain)msg.getInterceptorChain();
                chain = chain.cloneChain();
                ep.put((Object)WSRM_RETRANSMIT_CHAIN, (Object)chain);
            }
        }
    }

    public PhaseInterceptorChain getRetransmitChain(Message msg) {
        Endpoint ep = msg.getExchange().getEndpoint();
        PhaseInterceptorChain pic = (PhaseInterceptorChain)ep.get((Object)WSRM_RETRANSMIT_CHAIN);
        if (pic == null) {
            return null;
        }
        return pic.cloneChain();
    }

    class DefaultSequenceIdentifierGenerator
    implements SequenceIdentifierGenerator {
        DefaultSequenceIdentifierGenerator() {
        }

        @Override
        public Identifier generateSequenceIdentifier() {
            String sequenceID = RMContextUtils.generateUUID();
            Identifier sid = new Identifier();
            sid.setValue(sequenceID);
            return sid;
        }
    }
}

