/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.SessionID;
import org.jboss.marshalling.FieldSetter;

public final class StatefulEJBLocator<T>
extends EJBLocator<T> {
    private static final long serialVersionUID = 8229686118358785586L;
    private static final FieldSetter hashCodeSetter = FieldSetter.get(StatefulEJBLocator.class, "hashCode");
    private final SessionID sessionId;
    private final String sessionOwnerNode;
    private final transient int hashCode;

    public StatefulEJBLocator(Class<T> viewType, String appName, String moduleName, String beanName, String distinctName, SessionID sessionId, Affinity affinity, String sessionOwnerNode) {
        super(viewType, appName, moduleName, beanName, distinctName, affinity);
        if (sessionId == null) {
            throw Logs.MAIN.paramCannotBeNull("Session id");
        }
        if (sessionOwnerNode == null || sessionOwnerNode.trim().isEmpty()) {
            throw Logs.MAIN.paramCannotBeNullOrEmptyString("Session owning node");
        }
        this.sessionId = sessionId;
        this.sessionOwnerNode = sessionOwnerNode;
        this.hashCode = sessionId.hashCode() * 13 + super.hashCode();
    }

    public StatefulEJBLocator(StatefulEJBLocator<T> original, Affinity newAffinity) {
        this(original.getViewType(), original.getAppName(), original.getModuleName(), original.getBeanName(), original.getDistinctName(), original.sessionId, newAffinity, original.sessionOwnerNode);
    }

    @Override
    public EJBLocator<T> withNewAffinity(Affinity affinity) {
        return new StatefulEJBLocator<T>(this, affinity);
    }

    @Override
    public <S> StatefulEJBLocator<? extends S> narrowTo(Class<S> type) {
        return (StatefulEJBLocator)super.narrowTo(type);
    }

    @Override
    public <S> StatefulEJBLocator<? extends S> narrowAsStateful(Class<S> type) {
        if (type.isAssignableFrom(this.getViewType())) {
            return this;
        }
        throw new ClassCastException(type.toString());
    }

    public SessionID getSessionId() {
        return this.sessionId;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof StatefulEJBLocator && this.equals((StatefulEJBLocator)other);
    }

    @Override
    public boolean equals(EJBLocator<?> other) {
        return other instanceof StatefulEJBLocator && this.equals((StatefulEJBLocator)other);
    }

    @Override
    public boolean equals(StatefulEJBLocator<?> other) {
        return super.equals(other) && this.sessionId.equals((Object)other.sessionId);
    }

    String getSessionOwnerNode() {
        return this.sessionOwnerNode;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        hashCodeSetter.setInt(this, this.sessionId.hashCode() * 13 + super.hashCode());
    }

    @Override
    public String toString() {
        return String.format("%s, session ID is %s", super.toString(), this.getSessionId());
    }
}

