/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.jca;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jboss.as.cli.ArgumentValueConverter;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.OperationCommandWithDescription;
import org.jboss.as.cli.handlers.ResourceCompositeOperationHandler;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class XADataSourceAddCompositeHandler
extends ResourceCompositeOperationHandler
implements OperationCommandWithDescription {
    private static final String XA_DATASOURCE_PROPERTIES = "xa-datasource-properties";
    private ArgumentWithValue xaProps = new ArgumentWithValue((CommandHandlerWithArguments)this, null, ArgumentValueConverter.PROPERTIES, "--xa-datasource-properties");

    public XADataSourceAddCompositeHandler(CommandContext ctx, String nodeType) {
        super(ctx, "xa-data-source-add", nodeType, null, "add");
    }

    @Override
    protected Map<String, CommandArgument> loadArguments(CommandContext ctx) {
        Map<String, CommandArgument> args = super.loadArguments(ctx);
        args.put(this.xaProps.getFullName(), this.xaProps);
        return args;
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ModelNode req = super.buildRequestWithoutHeaders(ctx);
        ModelNode steps = req.get("steps");
        ModelNode xaPropsNode = this.xaProps.toModelNode(ctx);
        if (xaPropsNode != null) {
            List propsList = xaPropsNode.asPropertyList();
            for (Property prop : propsList) {
                ModelNode address = this.buildOperationAddress(ctx);
                address.add(XA_DATASOURCE_PROPERTIES, prop.getName());
                ModelNode addProp = new ModelNode();
                addProp.get("address").set(address);
                addProp.get("operation").set("add");
                addProp.get("value").set(prop.getValue());
                steps.add(addProp);
            }
        }
        return req;
    }

    @Override
    public ModelNode getOperationDescription(CommandContext ctx) throws CommandLineException {
        ModelNode response;
        ModelNode request = this.initRequest(ctx);
        if (request == null) {
            return null;
        }
        request.get("operation").set("read-operation-description");
        request.get("name").set("add");
        try {
            response = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            throw new CommandFormatException("Failed to execute read-operation-description.", e);
        }
        if (!response.hasDefined("result")) {
            return null;
        }
        ModelNode result = response.get("result");
        ModelNode opDescr = result.get("description");
        StringBuilder buf = new StringBuilder();
        buf.append(opDescr.asString());
        buf.append(" (unlike the add operation, this command accepts xa-datasource-properties).");
        opDescr.set(buf.toString());
        ModelNode allProps = result.get("request-properties");
        ModelNode xaProps = allProps.get(XA_DATASOURCE_PROPERTIES);
        xaProps.get("description").set("A comma-separated list of XA datasource properties in key=value pair format.");
        xaProps.get("type").set(ModelType.LIST);
        xaProps.get("required").set(false);
        xaProps.get("nillable").set(false);
        return result;
    }
}

